% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submission.R
\name{as.document.submission}
\alias{as.document.submission}
\title{Coerce a submission object to a document.}
\usage{
\method{as.document}{submission}(x, title, short = title, protocol = "~",
  sponsor = "~", program = "~", author = "~",
  date = "\\\\mydate \\\\today", lhead1 = short, lhead2 = protocol,
  rhead1 = sponsor, rhead2 = program, lfoot = author, rfoot = date,
  logo = NULL, logoscale = 1, morePreamble = NULL, geoLeft = "1in",
  geoRight = "1in", geoTop = "1in", geoBottom = "1in", pagestyle = NULL,
  thispagestyle = NULL, units = FALSE, ...)
}
\arguments{
\item{x}{a list of artifacts each having attributes: x, tag, des, file, spec}

\item{title}{a title for the document}

\item{short}{short title}

\item{protocol}{relevant protocol}

\item{sponsor}{program sponsor}

\item{program}{drug development program}

\item{author}{document author}

\item{date}{today's date by default}

\item{lhead1}{left header 1, e.g. short title}

\item{lhead2}{left header 2, e.g. relevant protocol(s)}

\item{rhead1}{right header 1, e.g. sponsor}

\item{rhead2}{right header 2, e.g. development program}

\item{lfoot}{left footer (italicized), e.g. responsible party}

\item{rfoot}{right footer, today's date by default}

\item{logo}{file path for title page logo}

\item{logoscale}{size adjustment for logo}

\item{morePreamble}{if NULL, a special value is passed to \code{\link[latexpdf]{as.document.character}}.  See function definition for details, and override if necessary.}

\item{geoLeft}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{geoRight}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{geoTop}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{geoBottom}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{pagestyle}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{thispagestyle}{passed to \code{\link[latexpdf]{as.document.character}}}

\item{units}{Should units for continuous variables be printed in Codes column?}

\item{...}{passed to as.define, as.tabular, as.document.character}
}
\description{
Coerces a submission object to a document.
}
\details{
Makes a pdf-ready character object representing a latex document.  
Essentially a wrapper for as.document.  Title, logo, headers,
footers, date are placed on the title page.  The second 
page has a menu (table) of defined objects that creates bi-directional links
to any defined data tables.  Links are also created to the storage locations
relative to the (resulting) define.pdf.  Following pages table the attributes
of data items in any datasets.
}
