% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_GP.R
\name{deepspat_GP}
\alias{deepspat_GP}
\title{Deep compositional spatial model}
\usage{
deepspat_GP(
  f,
  data,
  g = ~1,
  layers = NULL,
  method = c("REML"),
  family = c("exp_stat", "exp_nonstat", "matern_stat", "matern_nonstat"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  nsteps = 150L
)
}
\arguments{
\item{f}{formula identifying the dependent variables and the spatial inputs in the covariance}

\item{data}{data frame containing the required data}

\item{g}{formula identifying the independent variables in the linear trend}

\item{layers}{list containing the nonstationary warping layers}

\item{method}{identifying the method for finding the estimates}

\item{family}{identifying the family of the model constructed}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{nsteps}{number of steps when doing gradient descent times two or three (depending on the family of model)}
}
\value{
\code{deepspat_GP} returns an object of class \code{deepspat_GP} with the following items
\describe{
 \item{"f"}{The formula used to construct the covariance model}
 \item{"g"}{The formula used to construct the linear trend model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"X"}{The model matrix of the linear trend}
 \item{"layers"}{The warping function layers in the model}
 \item{"Cost"}{The final value of the cost}
 \item{"eta_tf"}{Estimated weights in the warping layers as a list of \code{TensorFlow} objects}
 \item{"a_tf"}{Estimated parameters in the LFT layers}
 \item{"beta"}{Estimated coefficients of the linear trend}
 \item{"precy_tf"}{Precision of measurement error, as a \code{TensorFlow} object}
 \item{"sigma2_tf"}{Variance parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf"}{Length scale parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf"}{Smoothness parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each warping layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Method used for inference}
 \item{"nlayers"}{Number of warping layers in the model}
 \item{"swarped_tf"}{Spatial locations on the warped domain}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"z_tf"}{Data of the process}
 \item{"family"}{Family of the model}
 }
}
\description{
Constructs a deep compositional spatial model
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow")) {
df <- data.frame(s1 = rnorm(100), s2 = rnorm(100), z = rnorm(100))
layers <- c(AWU(r = 50L, dim = 1L, grad = 200, lims = c(-0.5, 0.5)),
            AWU(r = 50L, dim = 2L, grad = 200, lims = c(-0.5, 0.5)))
d <- deepspat_GP(f = z ~ s1 + s2 - 1,
                 data = df, g = ~ 1,
                 layers = layers, method = "REML",
                 family = "matern_nonstat",
                 nsteps = 10L)
 }
}
}
