% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_lang2.R
\name{toPortuguese2}
\alias{toPortuguese2}
\title{Translate texts into Portuguese using DeepL API Free}
\usage{
toPortuguese2(
  text,
  source_lang = NULL,
  split_sentences = TRUE,
  preserve_formatting = FALSE,
  get_detect = FALSE,
  auth_key = "your_key"
)
}
\arguments{
\item{text}{character vector to be translated. Only UTF8-encoded plain text is supported.
An element can contain several sentences, but should not exceed 30kbytes.}

\item{source_lang}{language of the text to be translated. If parameter \code{is.null},
the API guesses the language of the source. If input is of length 1, the same source
language is applied to all elements.}

\item{split_sentences}{if \code{TRUE}, the translation engine splits the input into sentences.
If only one sentence is translated, it is recommended to set to \code{FALSE} to prevent
the engine from unintentionally splitting the sentence.}

\item{preserve_formatting}{if \code{TRUE}, the translation engine tries to preserve some aspects
(e.g. punctuation at the beginning and end of the sentence, upper/lower case at the beginning
of the sentence) of the formatting.}

\item{get_detect}{if \code{TRUE}, the language detected for the source text is included in
the response.}

\item{auth_key}{Authentication key.}
}
\value{
If \code{get_detect} is set to \code{FALSE} a \code{character vector} containing the
   translation is returned. Otherwise, a (\code{tibble}) is returned with the following columns:
\itemize{
\item \code{translation} the translated text.
\item \code{source_lang} detected or specified language of the input text.
}
}
\description{
\code{toPortuguese2} translates a text from an available language into Portuguese
    using DeepL API Free. Use \code{available_languages2} to list all supported languages.
    An authentication key is required to use this service. With the DeepL API Free package,
    developers can translate up to 500,000 characters per month for free.
}
\details{
To get an authentication key, you need to register for a DeepL API Free
    account (\url{https://www.deepl.com/pro#developer}).
}
\examples{
\dontrun{
# Translate a single text
toPortuguese2("Hallo Welt!", auth_key = "my_key")

# Translate multiple texts and return the detected language
texts <- c("My name is Fred.", "Je suis médecin.", "Ich komme aus der Schweiz.")
toPortuguese2(texts, get_detect = T, auth_key = "x")

}


}
\references{
\href{https://www.deepl.com/pro#developer}{DeepL API documentations}
}
