% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_normalization.R
\name{batch_normalization}
\alias{batch_normalization}
\title{Batch Normalization Function that normalizes the input before applying non-linearity}
\usage{
batch_normalization(x, gamma, beta, mu = NULL, sigma_2 = NULL,
  epsilon = exp(-12))
}
\arguments{
\item{x}{weighted sum of outputs from the previous layer}

\item{gamma}{the gamma coefficient}

\item{beta}{the beta coefficient}

\item{mu}{the mean of the input neurons. If NULL, it will be caluclated in the function.}

\item{sigma_2}{the variance of the input nerurons. If NULL, it will be calcualted in the function.}

\item{epsilon}{a constant added to the variance for numerical stability}
}
\description{
This function normalizes the distribution of inputs to hidden layers in
a neural network
}
\references{
Batch Normalization: Accelerating Deep Network Training by Reducing Internal Covariate Shift
Sergey Ioffe, Christian Szegedy
}
\seealso{
\url{http://jmlr.org/proceedings/papers/v37/ioffe15.pdf} Pg 4
}

