% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepboost.R
\docType{methods}
\name{predict,Deepboost-method}
\alias{predict,Deepboost-method}
\title{Predict method for Deepboost model}
\usage{
\S4method{predict}{Deepboost}(object, newdata, type = "terms")
}
\arguments{
\item{object}{Object of class "Deepboost"}

\item{newdata}{takes \code{data.frame}.}

\item{type}{Type of prediction}
}
\description{
Predicted values based on deepboost model object.
}
\details{
The option \code{ntreelimit} purpose is to let the user train a model with lots
of trees but use only the first trees for prediction to avoid overfitting
(without having to train a new model with less trees).
}
\examples{
dpb <- deepboost(y ~ .,
 data.frame(x1=rep(c(0,0,1,1),2),x2=rep(c(0,1,0,1),2),y=factor(rep(c(0,0,0,1),2))),
 num_iter=2,tree_depth=2)
predict(dpb,data.frame(x1=rep(c(1,1,1,0),2),x2=rep(c(1,1,1,1),2)))
}
