% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorator-validate_arguments.R
\name{validate_arguments}
\alias{validate_arguments}
\title{Validate the Type of Input Arguments}
\usage{
validate_arguments(func)
}
\arguments{
\item{func}{(\code{function}) A function to decorate.}
}
\value{
(\code{closure}) An object that contains the original function bound to the environment of the decorator.
}
\description{
Wrap a function with a input validation.
}
\details{
\if{html}{\out{
<!-- One line about what the function does -->
}}


\code{validate_arguments} decorator allows the arguments passed to a function
to be parsed and validated using the function’s annotations before the
function is called.
\subsection{How It Works}{

\code{validate_arguments} provides an extremely easy way to apply validation
to your code with minimal boilerplate. The original function needs to
have key-value pairs in its declaration, where the each value carries
its designated class.
}

\subsection{When to Use It}{
\itemize{
\item To protect functions from receiving unexpected types of input
arguments.
\item In
\href{https://tidylab.github.io/R6P/reference/ValueObject.html}{\code{ValueObjects}}.
}
}

\subsection{Examples: Functions with Built-in NA classes}{

Given a \code{Customer}
\href{https://tidylab.github.io/R6P/reference/ValueObject.html}{\code{ValueObject}}\if{html}{\out{<div class="r">}}\preformatted{Customer <- function(given = NA_character_, family = NA_character_)
    return(data.frame(given = given, family = family))
}\if{html}{\out{</div>}}

When \code{Customer} is decorated with \code{validate_arguments}\if{html}{\out{<div class="r">}}\preformatted{Customer <- validate_arguments(Customer)
}\if{html}{\out{</div>}}

Then passing arguments of any type other then the declared type prompts
an informative error.

In the \code{Customer} example, both input arguments \code{given} and \code{family} are
declared as \code{character}.\if{html}{\out{<div class="r">}}\preformatted{Customer(given = "Bilbo", family = "Baggins") # Works as both arguments are character
#>   given  family
#> 1 Bilbo Baggins
try(Customer(given = "Bilbo", family = 90201)) # Fails because family is not a character
#> Error in Customer(given = "Bilbo", family = 90201) : 
#>   family is of type `numeric` rather than `character`!
}\if{html}{\out{</div>}}
}
}
\note{
The original function must have default values of the designated type.
}
\examples{
Car <- function(model = NA_character_, hp = NA_real_){
    return(data.frame(model = model, hp = hp))
}

Car <- validate_arguments(Car)
try(Car(model = 555, hp = 120)) # fails because model is numeric rather than character

}
\references{
\itemize{
\item \href{https://pydantic-docs.helpmanual.io/usage/validation_decorator/}{Similar Python module}
\item \href{http://adv-r.had.co.nz/Functional-programming.html}{Closures in R}
}
}
\concept{defensive programming}
