% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconv.R
\name{deconv}
\alias{deconv}
\title{A function to compute Empirical Bayes estimates using deconvolution}
\usage{
deconv(tau, X, y, Q, P, n = 40, family = c("Poisson", "Normal", "Binomial"),
  ignoreZero = TRUE, deltaAt = NULL, c0 = 1, scale = TRUE,
  pDegree = 5, aStart = 1, ...)
}
\arguments{
\item{tau}{a vector of (implicitly m) discrete support points for
\eqn{\theta}}

\item{X}{the vector of sample values: a vector of counts for
Poisson, a vector of z-scores for Normal, a 2-d matrix with
rows consisting of pairs, (trial size \eqn{n_i}, number of
successes \eqn{X_i}) for Binomial. See details below}

\item{y}{the multinomial counts. See details below}

\item{Q}{the Q matrix, implies y and P are supplied as well; see
details below}

\item{P}{the P matrix, implies Q and y are supplied as well; see
details below}

\item{n}{the number of support points for X. Applies only to
Poisson and Normal. In the former, implies that support of X is
1 to n or 0 to n-1 depending on the \code{ignoreZero} parameter
below. In the latter, the range of X is divided into n bins to
construct the multinomial sufficient statistic y (\eqn{y_k} =
number of X in bin K) described in the references below}

\item{family}{the exponential family, one of \code{c("Poisson",
"Normal", "Binomial")} with \code{"Poisson"}, the default}

\item{ignoreZero}{if the zero values should be ignored (default =
\code{TRUE}). Applies to Poisson only and has the effect of
adjusting \code{P} for the truncation at zero}

\item{deltaAt}{the theta value where a delta function is desired
(default \code{NULL}). Applies to Normal only if non-null}

\item{c0}{the regularization parameter (default 1)}

\item{scale}{if the Q matrix should be scaled so that the spline
basis has mean 0 and columns sum of squares to be one, (default
\code{TRUE})}

\item{pDegree}{the degree of the splines to use (default 5). In
notation used in the references below, \eqn{p} = pDegree + 1}

\item{aStart}{the starting values for the non-linear optimization,
default is a vector of 1s}

\item{...}{further args to function \code{nlm}}
}
\value{
a list of 9 items consisting of
    \item{mle}{the maximum likelihood estimate \eqn{\hat{\alpha}}}
    \item{Q}{the m by p matrix Q}
    \item{P}{the n by m matrix P}
    \item{S}{the ratio of artificial to genuine information
             per the reference below, where it was referred to as
             \eqn{R(\alpha)}}
    \item{cov}{the covariance matrix for the mle}
    \item{cov.g}{the covariance matrix for the \eqn{g}}
    \item{mat}{an m by 6 matrix containing columns for \eqn{theta},
               \eqn{g}, std. error of \eqn{g}, \eqn{G}
               (the cdf of {g}), std. error of \eqn{G}, and
               the bias of \eqn{g}}
    \item{loglik}{the negative log-likelihood function for the
          data taking a \eqn{p}-vector argument}
    \item{statsFunction}{a function to compute the statistics
                         returned above}
}
\description{
A function to compute Empirical Bayes estimates using deconvolution
}
\section{Details}{

The data \code{X} is always required with two exceptions. In the Poisson case,
\code{y} alone may be specified and \code{X} omitted, in which case the sample space of
the observations $\eqn{X}$ is assumed to be 1, 2, .., \code{length(y)}. The second exception is
for experimentation with other exponential families besides the three implemented here:
\code{y}, \code{P} and \code{Q} can be specified together.
}
\examples{
set.seed(238923) ## for reproducibility
N <- 1000
theta <- rchisq(N,  df = 10)
X <- rpois(n = N, lambda = theta)
tau <- seq(1, 32)
result <- deconv(tau = tau, X = X, ignoreZero = FALSE)
print(result$stats)

}
\references{
Bradley Efron. Empirical Bayes Deconvolution Estimates. Biometrika 103(1), 1-20,
ISSN 0006-3444. doi:10.1093/biomet/asv068.
\url{http://biomet.oxfordjournals.org/content/103/1/1.full.pdf+html}

Bradley Efron and Trevor Hastie. Computer Age Statistical Inference.
Cambridge University Press. ISBN 978-1-1-7-14989-2. Chapter 21.
}

