% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_simple_CPT.R
\name{sample_simple_CPT}
\alias{sample_simple_CPT}
\title{Make Conditional Probability tables using the likelihood method}
\usage{
sample_simple_CPT(parent_list, child_states_n, child_prior = NULL, b = 2,
  obs_states = NULL)
}
\arguments{
\item{parent_list}{named list of parameters for the parent nodes containing a
name and a vector of two elements: c(number_of_states,parent_weight).}

\item{child_states_n}{number of states for the child node.}

\item{child_prior}{prior distribution for the states of the child node.}

\item{b}{parameter for the strength of the parent's influence on
the child node. A value of 1 causes no response; 3 is quite strong. Defaults to 2.}

\item{obs_states}{optional vector of observed states for all parents. This has to
be complete and names have to correspond exactly with the names of states of the parent
nodes. It's also important that the name are given in the exact same sequence as the
parents are listed in parent_list.}
}
\value{
list of two data.frames: 1) Conditional Probability Table (CPT); 2) legend table
specifying which states of the parent nodes belong to which column in the CPT. If obs_states
are given, an additional attribute $sampled specified one random draw, according to the
CPT and the obs_states provided.
}
\description{
This function creates Conditional Probability Tables for
Bayesian Network nodes from parameters that (for complex nodes) can
be more easily elicited from experts than the full table. The function
uses the Likelihood method. The function combines the make_CPT and sample_CPT
functions, but only offers limited flexibility. Refer to the make_CPR and
sample_CPT descriptions for details.
}
\examples{

parent_list<-list(pare1=c(5,3),parent2=c(3,2),PARE3=c(4,5))
sample_simple_CPT(parent_list,5)
sample_simple_CPT(parent_list,5,obs_states=c("very high","medium","high"))

sample_simple_CPT(parent_list=list(management_intensity=c(5,2),inputs=c(5,1)),5,
     obs_states=c("medium","very high"))$sampled

}
\author{
Eike Luedeling
}
\keyword{~kwd1}
\keyword{~kwd2}
