% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_profit.R
\name{model_profit}
\alias{model_profit}
\title{Profit efficiency DEA model.}
\usage{
model_profit(datadea,
             dmu_eval = NULL,
             dmu_ref = NULL,
             price_input = NULL,
             price_output = NULL,
             rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
             L = 1,
             U = 1,
             restricted_optimal = TRUE,
             returnlp = FALSE,
             ...)
}
\arguments{
\item{datadea}{The data, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{price_input}{Unit prices of inputs for cost or profit efficiency models.
It is a value, vector of length \code{m}, or matrix \code{m} x \code{ne} (where \code{ne}
is the length of \code{dmu_eval}).}

\item{price_output}{Unit prices of outputs for revenue or profit efficiency models.
It is a value, vector of length \code{s}, or matrix \code{s} x \code{ne}.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{restricted_optimal}{Logical. If it is \code{TRUE}, the optimal inputs are
restricted to be <= inputs (for cost efficiency models) or the optimal outputs are
restricted to be >= outputs (for revenue efficiency models).}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems
(objective function and constraints) of stage 1.}

\item{...}{Ignored, for compatibility issues.}
}
\description{
Cost, revenue and profit efficiency DEA models.
}
\examples{
# Example 1. Replication of results in Coelli et al. (1998, p.166).
# Cost efficiency model.
data("Coelli_1998")
# Selection of prices: input_prices is the transpose where the prices for inputs are. 
input_prices <- t(Coelli_1998[, 5:6]) 

data_example1 <- read_data(Coelli_1998,
                           ni = 2,
                           no = 1)
result1 <- model_profit(data_example1,
                       price_input = input_prices,
                       rts = "crs", 
                       restricted_optimal = FALSE) 
# notice that the option by default is restricted_optimal = TRUE
efficiencies(result1)

# Example 2. Revenue efficiency model.
data("Coelli_1998")
# Selection of prices for output: output_prices is the transpose where the prices for outputs are. 
output_prices <- t(Coelli_1998[, 7]) 
data_example2 <- read_data(Coelli_1998,
                          ni = 2,
                          no = 1)
result2 <- model_profit(data_example2,
                       price_output = output_prices,
                       rts = "crs", 
                       restricted_optimal = FALSE) 
# notice that the option by default is restricted_optimal = TRUE
efficiencies(result2)

# Example 3. Profit efficiency model.
data("Coelli_1998")
# Selection of prices for inputs and outputs: input_prices and output_prices are 
# the transpose where the prices (for inputs and outputs) are. 
input_prices <- t(Coelli_1998[, 5:6]) 
output_prices <- t(Coelli_1998[, 7]) 
data_example3 <- read_data(Coelli_1998,
                           ni = 2,
                           no = 1)
result3 <- model_profit(data_example3,
                        price_input = input_prices,
                        price_output = output_prices,
                        rts = "crs", 
                        restricted_optimal = FALSE) 
# notice that the option by default is restricted_optimal = TRUE
efficiencies(result3)

}
\references{
Coelli, T.; Prasada Rao, D.S.; Battese, G.E. (1998). An introduction to efficiency
and productivity analysis. Jossey-Bass, San Francisco, pp 73–104. \doi{10.1002/ev.1441}
}
\seealso{
\code{\link{model_deaps}}, \code{\link{model_nonradial}},
\code{\link{model_sbmeff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
