% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_sbmsupereff.R
\name{model_sbmsupereff}
\alias{model_sbmsupereff}
\title{Slack based measure of superefficiency model}
\usage{
model_sbmsupereff(datadea,
                  dmu_eval = NULL,
                  dmu_ref = NULL,
                  weight_input = 1,
                  weight_output = 1,
                  orientation = c("no", "io", "oo"),
                  rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
                  L = 1,
                  U = 1,
                  compute_target = TRUE,
                  compute_rho = FALSE,
                  kaizen = FALSE,
                  silent = FALSE,
                  returnlp = FALSE)
}
\arguments{
\item{datadea}{The data, including DMUs, inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{weight_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne} (where \code{ne} is the lenght of \code{dmu_eval})
with weights to inputs corresponding to the relative importance of items.}

\item{weight_output}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne} (where \code{ne} is the lenght of \code{dmu_eval})
with weights to outputs corresponding to the relative importance of items.}

\item{orientation}{A string, equal to "no" (non-oriented), "io" (input-oriented) or "oo" (output-oriented).}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{compute_target}{Logical. If it is \code{TRUE}, it computes targets, superslacks (\code{t_input} and \code{t_output}) and slacks.}

\item{compute_rho}{Logical. If it is \code{TRUE}, it computes the SBM efficiency score (applying \code{model_sbmeff})
of the DMU (\code{project_input}, \code{project_output}).}

\item{kaizen}{Logical. If \code{TRUE}, the kaizen version of SBM (Tone 2010), also known as SBM-Max, is computed for the efficiency score
of the DMU (\code{project_input}, \code{project_output}).}

\item{silent}{Logical. If \code{FALSE} (default) it prints all the messages from function \code{maximal_friends}.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems (objective function and constraints).}
}
\description{
Slack based measure of superefficiency model (Tone 2002) with n DMUs, m inputs, s outputs...
}
\examples{
# Replication of results in Tone(2002, p.39)
data("Power_plants")
data_example <- read_data(Power_plants,
                          ni = 4,
                          no = 2)
result <- model_sbmsupereff(data_example,
                            orientation = "io",
                            rts = "crs") 
efficiencies(result)
slacks(result)$slack_input
references(result)

}
\references{
Tone, K. (2002). "A slacks-based measure of super-efficiency in data envelopment analysis", European Journal of Operational Research, 143, 32-41. \doi{10.1016/S0377-2217(01)00324-1}  

Tone, K. (2010). "Variations on the theme of slacks-based measure of efficiency in DEA", European Journal of Operational Research, 200, 901-907. \doi{10.1016/j.ejor.2009.01.027}
  
Cooper, W.W.; Seiford, L.M.; Tone, K. (2007). Data Envelopment Analysis. A Comprehensive Text with Models, Applications, References and DEA-Solver Software. 2nd Edition. Springer, New York. \doi{10.1007/978-0-387-45283-8}
}
\seealso{
\code{\link{model_sbmeff}}, \code{\link{model_supereff}}, \code{\link{model_addsupereff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
