`ddst.exp.test` <-
function(x, base = ddst.base.legendre, c = 100, B=1000, compute.p = F, Dmax = 5, ...) {

# method.name = as.character(substitute(base)) 
 # only Legendre is implemented yet
 base = ddst.base.legendre
 method.name = "ddst.base.legendre"

n = length(x)
if(n<5) 
	stop("length(x) should be at least 5")

er = .Internal(mean(x))
maxN = max(min(Dmax, n-2, 20),1)
coord = numeric(maxN)
u = numeric(maxN)
for (j in 1:maxN) { 
u[j] = ddst.phi(pexp(x,1/er), j, base)
coord[j] = t(u[1:j]) %*% MMexp[[j]] %*% u[1:j] * n
}

l = ddst.IIC(coord, n, c)
attr(l, "names") = "n. coord"
t = coord[l]
attr(t, "names") = "WT*"
result = list(statistic = t, parameter = l, method = "Data Driven Smooth Test for Expotentiality")
result$data.name = paste(paste(as.character(substitute(x)), collapse=""), ",   base: ", method.name, ",   c: ", c, sep="")
class(result) = "htest"
if (compute.p) {
tmp = numeric(B)
for (i in 1:B) {
y = rexp(length(x))
tmpC = ddst.exp.Nk(y, base, Dmax = Dmax, n=length(y))
l = ddst.IIC(tmpC, n, c)
tmp[i] = tmpC[l]
}
p.val = .Internal(mean(tmp > t))
result$p.value = p.val  
}
result
}

`MMexp` <-
list(structure(4, .Dim = c(1L, 1L)), structure(c(7.75, 2.90473750965556, 
2.90473750965556, 2.25), .Dim = c(2L, 2L)), structure(c(13.0000000000001, 
5.16397779494326, 3.05505046330393, 5.16397779494326, 3.22222222222224, 
1.31468439624438, 3.05505046330393, 1.31468439624438, 1.77777777777779
), .Dim = c(3L, 3L)), structure(c(19.7499999999998, 8.06871530459869, 
4.7735163489123, 3.24759526419154, 8.06871530459869, 4.47222222222218, 
2.05419436913180, 1.39754248593732, 4.7735163489123, 2.05419436913180, 
2.21527777777777, 0.826797284707661, 3.24759526419154, 1.39754248593732, 
0.826797284707661, 1.56249999999997), .Dim = c(4L, 4L)), structure(c(28.0000000000111, 
11.6189500386270, 6.87386354243662, 4.67653718043779, 3.44673758792592, 
11.6189500386270, 6.00000000000206, 2.95803989155104, 2.01246117975060, 
1.48323969742047, 6.87386354243662, 2.95803989155104, 2.75000000000074, 
1.19058808997954, 0.877496438740007, 4.67653718043779, 2.01246117975060, 
1.19058808997954, 1.8100000000003, 0.596992462264497, 3.44673758792592, 
1.48323969742047, 0.877496438740007, 0.596992462264497, 1.44000000000061
), .Dim = c(5L, 5L)), structure(c(37.7499999996889, 15.8146819968797, 
9.356092043789, 6.3652867177616, 4.69139282796864, 3.64291549898935, 
15.8146819968797, 7.80555555549795, 4.02622096346428, 2.73918327241400, 
2.01885403258216, 1.56766122880296, 9.356092043789, 4.02622096346428, 
3.3819444444243, 1.62052267801332, 1.19437015271885, 0.927440890247034, 
6.3652867177616, 2.73918327241400, 1.62052267801332, 2.10249999999062, 
0.812573073630574, 0.630971473192956, 4.69139282796864, 2.01885403258216, 
1.19437015271885, 0.812573073630574, 1.59888888888440, 0.465043473333310, 
3.64291549898935, 1.56766122880296, 0.927440890247034, 0.630971473192956, 
0.465043473333310, 1.36111111109903), .Dim = c(6L, 6L)), structure(c(49.0000000062404, 
20.6559111824583, 12.2202018548044, 8.3138438774113, 6.12753349044019, 
4.75809371362456, 3.83325939138121, 20.6559111824583, 9.88888889004452, 
5.25873758566114, 3.57770876446472, 2.63687057353367, 2.04755752361801, 
1.64957219827918, 12.2202018548044, 5.25873758566114, 4.11111111151561, 
2.11660104912681, 1.55999366907329, 1.21135136702101, 0.975900073300267, 
8.3138438774113, 3.57770876446472, 2.11660104912681, 2.44000000018715, 
1.06131993305220, 0.824126005917164, 0.663940002446266, 6.12753349044019, 
2.63687057353367, 1.55999366907329, 1.06131993305220, 1.78222222232468, 
0.607403720356187, 0.489342193649563, 4.75809371362456, 2.04755752361801, 
1.21135136702101, 0.824126005917164, 0.607403720356187, 1.47165532884771, 
0.379979321051083, 3.83325939138121, 1.64957219827918, 0.975900073300267, 
0.663940002446266, 0.489342193649563, 0.379979321051083, 1.30612244916046
), .Dim = c(7L, 7L)), structure(c(61.7499999643167, 26.1426375715444, 
15.4661929613915, 10.5222086498002, 7.75515956827492, 6.02196235198601, 
4.85146891373646, 4.01705348301015, 26.1426375715444, 12.249999993392, 
6.65558975207775, 4.52803765177731, 3.33728931723443, 2.59143998896998, 
2.08773981194937, 1.72866458228031, 15.4661929613915, 6.65558975207775, 
4.93749999768723, 2.67882320087937, 1.9743669860045, 1.53311657278613, 
1.23512352938459, 1.02269175869889, 10.5222086498002, 4.52803765177731, 
2.67882320087937, 2.82249999892943, 1.34323303930558, 1.04303447549065, 
0.840299064993236, 0.695774072929495, 7.75515956827492, 3.33728931723443, 
1.9743669860045, 1.34323303930558, 1.98999999941946, 0.768745333024312, 
0.619323713393434, 0.512804786392375, 6.02196235198601, 2.59143998896998, 
1.53311657278613, 1.04303447549065, 0.768745333024312, 1.59693877514465, 
0.480911327860278, 0.398198269214986, 4.85146891373646, 2.08773981194937, 
1.23512352938459, 0.840299064993236, 0.619323713393434, 0.480911327860278, 
1.38743622444076, 0.320800166404736, 4.01705348301015, 1.72866458228031, 
1.02269175869889, 0.695774072929495, 0.512804786392375, 0.398198269214986, 
0.320800166404736, 1.26562499909206), .Dim = c(8L, 8L)), structure(c(75.9999998148397, 
32.2748611387149, 19.0940653485099, 12.9903810246956, 9.57427105393107, 
7.43452140821745, 5.98946778346764, 4.95932527833625, 4.19435243809508, 
32.2748611387149, 14.8888888546000, 8.21677745624167, 5.59016992994832, 
4.12011026043898, 3.19930862233875, 2.57745655311289, 2.13415380126909, 
1.80496190454075, 19.0940653485099, 8.21677745624167, 5.86111109911003, 
3.30718913066588, 2.43749010159244, 1.89273650605146, 1.52484386056889, 
1.26258241577133, 1.06782986327185, 12.9903810246956, 5.59016992994832, 
3.30718913066588, 3.2499999944451, 1.65831239108443, 1.28769688089909, 
1.03740625112627, 0.858980335333887, 0.726483152763092, 9.57427105393107, 
4.12011026043898, 2.43749010159244, 1.65831239108443, 2.22222221920599, 
0.949068310590093, 0.764597175590399, 0.63309232768836, 0.535438229829078, 
7.43452140821745, 3.19930862233875, 1.89273650605146, 1.28769688089909, 
0.949068310590093, 1.73696144940933, 0.593717687599357, 0.491602800575069, 
0.415773374288155, 5.98946778346764, 2.57745655311289, 1.52484386056889, 
1.03740625112627, 0.764597175590399, 0.593717687599357, 1.47831632557016, 
0.396049587408857, 0.334959184833341, 4.95932527833625, 2.13415380126909, 
1.26258241577133, 0.858980335333887, 0.63309232768836, 0.491602800575069, 
0.396049587408857, 1.32793209702753, 0.277348774984669, 4.19435243809508, 
1.80496190454075, 1.06782986327185, 0.726483152763092, 0.535438229829078, 
0.415773374288155, 0.334959184833341, 0.277348774984669, 1.23456789891182
), .Dim = c(9L, 9L)), structure(c(91.7500063635929, 39.0525848127125, 
23.1038207488272, 15.7183621808938, 11.5848688162142, 8.99577155695548, 
7.24725654408169, 6.00078402238999, 5.07516681850665, 4.36549072927617, 
39.0525848127125, 17.8055567339987, 9.94230144377437, 6.76410610625093, 
4.9853337770217, 3.87116371404166, 3.1187226556579, 2.58232628698933, 
2.18400406303342, 1.87860809916772, 23.1038207488272, 9.94230144377437, 
6.8819448568996, 4.0016991385932, 2.94936323702418, 2.29021133857108, 
1.84506120522325, 1.52772483398243, 1.29207422835195, 1.11139953958534, 
15.7183621808938, 6.76410610625093, 4.0016991385932, 3.72250019090767, 
2.00655813887029, 1.55811333899295, 1.25526165498353, 1.03936628120268, 
0.879044678654103, 0.756125174307707, 11.5848688162142, 4.9853337770217, 
2.94936323702418, 2.00655813887029, 2.47888899259333, 1.14837273917558, 
0.925162649622896, 0.76604177211068, 0.647880305123485, 0.557285221716005, 
8.99577155695548, 3.87116371404166, 2.29021133857108, 1.55811333899295, 
1.14837273917558, 1.89172341851641, 0.718398454144509, 0.594839431875843, 
0.503085819408188, 0.432737791524058, 7.24725654408169, 3.1187226556579, 
1.84506120522325, 1.25526165498353, 0.925162649622896, 0.718398454144509, 
1.57876279595288, 0.479220035551796, 0.405300643069535, 0.348626215287706, 
6.00078402238999, 2.58232628698933, 1.52772483398243, 1.03936628120268, 
0.76604177211068, 0.594839431875843, 0.479220035551796, 1.39679786620728, 
0.335592042092423, 0.288665181059883, 5.07516681850665, 2.18400406303342, 
1.29207422835195, 0.879044678654103, 0.647880305123485, 0.503085819408188, 
0.405300643069535, 0.335592042092423, 1.28382717828662, 0.24413875638701, 
4.36549072927617, 1.87860809916772, 1.11139953958534, 0.756125174307707, 
0.557285221716005, 0.432737791524058, 0.348626215287706, 0.288665181059883, 
0.24413875638701, 1.21000008783516), .Dim = c(10L, 10L)), structure(c(108.999909639504, 
46.4757612695227, 27.4954311650789, 18.7061330708465, 13.7869388165529, 
10.7057018971028, 8.624826413336, 7.14142244340708, 6.03986247238459, 
5.19529004113727, 4.53087098633189, 46.4757612695227, 20.9999832665748, 
11.8321496665714, 8.04983798392535, 5.93295382574333, 4.60700057299338, 
3.71153434030891, 3.07317891017194, 2.59914297432541, 2.23569686756021, 
1.94977643043087, 27.4954311650789, 11.8321496665714, 7.99999414330124, 
4.76234837539283, 3.50998281825438, 2.72553829506146, 2.19577332749816, 
1.81811716203164, 1.53767372037920, 1.32265610393122, 1.15350329216362, 
18.7061330708465, 8.04983798392535, 4.76234837539283, 4.23999728918498, 
2.38796785111126, 1.85428196164682, 1.49386375543597, 1.23693065102935, 
1.04613486728985, 0.899850631130616, 0.784769875086638, 13.7869388165529, 
5.93295382574333, 3.50998281825438, 2.38796785111126, 2.75999852746031, 
1.36665722717996, 1.10101901437664, 0.911652191368105, 0.771030407757874, 
0.663214869072507, 0.57839716054173, 10.7057018971028, 4.60700057299338, 
2.72553829506146, 1.85428196164682, 1.36665722717996, 2.06122360187336, 
0.854952756938788, 0.707907442289478, 0.598713159526537, 0.514993268374537, 
0.449131432385561, 8.624826413336, 3.71153434030891, 2.19577332749816, 
1.49386375543597, 1.10101901437664, 0.854952756938788, 1.68877493424281, 
0.570310930113578, 0.482340823789774, 0.414893632053117, 0.36183341160907, 
7.14142244340708, 3.07317891017194, 1.81811716203164, 1.23693065102935, 
0.911652191368105, 0.707907442289478, 0.570310930113578, 1.47222182579071, 
0.399381902812281, 0.343535110572130, 0.299600840944936, 6.03986247238459, 
2.59914297432541, 1.53767372037920, 1.04613486728985, 0.771030407757874, 
0.598713159526537, 0.482340823789774, 0.399381902812281, 1.33777749265798, 
0.290545033392701, 0.253387597535103, 5.19529004113727, 2.23569686756021, 
1.32265610393122, 0.899850631130616, 0.663214869072507, 0.514993268374537, 
0.414893632053117, 0.343535110572130, 0.290545033392701, 1.24991723327949, 
0.217955635255067, 4.53087098633189, 1.94977643043087, 1.15350329216362, 
0.784769875086638, 0.57839716054173, 0.449131432385561, 0.36183341160907, 
0.299600840944936, 0.253387597535103, 0.217955635255067, 1.19008156546897
), .Dim = c(11L, 11L)), structure(c(127.750817320277, 54.5448671777347, 
32.2691785982051, 21.9538855499597, 16.1806224577019, 12.5644222293746, 
10.1222658498964, 8.38131378584157, 7.08850134627143, 6.09729453596856, 
5.31751927022201, 4.69110156706042, 54.5448671777347, 24.4723735778291, 
13.8864434785157, 9.44744812439306, 6.96303125666103, 5.40686644989844, 
4.35592967361478, 3.60674319021145, 3.05040529596424, 2.62385779941419, 
2.28829595296743, 2.01872869384361, 32.2691785982051, 13.8864434785157, 
9.21533075224026, 5.58918568506044, 4.11938484466232, 3.19874532941639, 
2.57700274786762, 2.13377804704423, 1.80464411017141, 1.55229520808426, 
1.35377414250993, 1.19429600132113, 21.9538855499597, 9.44744812439306, 
5.58918568506044, 4.80252451960815, 2.80256601948291, 2.17622176690241, 
1.75322787397396, 1.45168613112547, 1.22776444812623, 1.05608239250094, 
0.92102135462509, 0.812522625761445, 16.1806224577019, 6.96303125666103, 
4.11938484466232, 2.80256601948291, 3.06556887485098, 1.60393579142739, 
1.29217756221491, 1.06993293562407, 0.904896445638785, 0.778362009695168, 
0.678818279377299, 0.598851707405877, 12.5644222293746, 5.40686644989844, 
3.19874532941639, 2.17622176690241, 1.60393579142739, 2.24547288369041, 
1.00338936462015, 0.83081409231548, 0.702661535215176, 0.604406224957035, 
0.527109479342321, 0.465014601527138, 10.1222658498964, 4.35592967361478, 
2.57700274786762, 1.75322787397396, 1.29217756221491, 1.00338936462015, 
1.80835980471101, 0.669328120364857, 0.566084674018348, 0.486927323728754, 
0.424654805807897, 0.374629356989992, 8.38131378584157, 3.60674319021145, 
2.13377804704423, 1.45168613112547, 1.06993293562407, 0.83081409231548, 
0.669328120364857, 1.55420881901880, 0.468722453318310, 0.403179559951243, 
0.351617437332770, 0.31019598189602, 7.08850134627143, 3.05040529596424, 
1.80464411017141, 1.22776444812623, 0.904896445638785, 0.702661535215176, 
0.566084674018348, 0.468722453318310, 1.39642230636767, 0.340989363544816, 
0.297380666276484, 0.26234844458304, 6.09729453596856, 2.62385779941419, 
1.55229520808426, 1.05608239250094, 0.778362009695168, 0.604406224957035, 
0.486927323728754, 0.403179559951243, 0.340989363544816, 1.29330777855588, 
0.255797018723013, 0.225663459670135, 5.31751927022201, 2.28829595296743, 
1.35377414250993, 0.92102135462509, 0.678818279377299, 0.527109479342321, 
0.424654805807897, 0.351617437332770, 0.297380666276484, 0.255797018723013, 
1.22308346239483, 0.196803645994492, 4.69110156706042, 2.01872869384361, 
1.19429600132113, 0.812522625761445, 0.598851707405877, 0.465014601527138, 
0.374629356989992, 0.31019598189602, 0.26234844458304, 0.225663459670135, 
0.196803645994492, 1.17361966082530), .Dim = c(12L, 12L)), structure(c(147.996562053869, 
63.2572485315976, 37.4234929172294, 25.4605514015246, 18.7651324343239, 
14.5713212029584, 11.7390823316768, 9.72005023762722, 8.22073853285857, 
7.07120753590464, 6.16687977169189, 5.44040517593633, 4.8455723556124, 
63.2572485315976, 28.2215855655312, 16.1045072028156, 10.9564768403736, 
8.07522726750147, 6.27049826125522, 5.05169670781577, 4.18284363273663, 
3.53764260347632, 3.04296322490390, 2.65380251709179, 2.34117762700245, 
2.08520233734776, 37.4234929172294, 16.1045072028156, 10.5275549479360, 
6.4819391129334, 4.77736887812004, 3.70967679933735, 2.98862407634599, 
2.47460366515002, 2.09289758862582, 1.80024132155696, 1.57001074197057, 
1.38505936277544, 1.23362233916552, 25.4605514015246, 10.9564768403736, 
6.4819391129334, 5.40989686161587, 3.2502162787007, 2.52382686569291, 
2.03326870326979, 1.68356208636919, 1.42387368146500, 1.22476907230505, 
1.06813490887389, 0.942305817848223, 0.83927775116717, 18.7651324343239, 
8.07522726750147, 4.77736887812004, 3.2502162787007, 3.39549952976909, 
1.86013038873919, 1.49857541927151, 1.24083194483497, 1.04943438895196, 
0.902688770593242, 0.787245048492656, 0.694505519016251, 0.618570976781375, 
14.5713212029584, 6.27049826125522, 3.70967679933735, 2.52382686569291, 
1.86013038873919, 2.44441066262473, 1.16365945497522, 0.963518956786588, 
0.814896756863755, 0.700947252498923, 0.611303997303143, 0.539290784663079, 
0.48032682002406, 11.7390823316768, 5.05169670781577, 2.98862407634599, 
2.03326870326979, 1.49857541927151, 1.16365945497522, 1.93747807475515, 
0.776239038609117, 0.65650464960568, 0.564703597747668, 0.492484370776738, 
0.434468421476367, 0.386965327840699, 9.72005023762722, 4.18284363273663, 
2.47460366515002, 1.68356208636919, 1.24083194483497, 0.963518956786588, 
0.776239038609117, 1.64273187958895, 0.543590886843331, 0.46757891157001, 
0.407780837542892, 0.359743186400301, 0.320410260406975, 8.22073853285857, 
3.53764260347632, 2.09289758862582, 1.42387368146500, 1.04943438895196, 
0.814896756863755, 0.65650464960568, 0.543590886843331, 1.45974233057818, 
0.39545515522294, 0.344880896929245, 0.304253023603323, 0.270987176985400, 
7.07120753590464, 3.04296322490390, 1.80024132155696, 1.22476907230505, 
0.902688770593242, 0.700947252498923, 0.564703597747668, 0.46757891157001, 
0.39545515522294, 1.34015745210089, 0.296655146932111, 0.261708393318463, 
0.233094211715109, 6.16687977169189, 2.65380251709179, 1.57001074197057, 
1.06813490887389, 0.787245048492656, 0.611303997303143, 0.492484370776738, 
0.407780837542892, 0.344880896929245, 0.296655146932111, 1.25871629640267, 
0.228238838789949, 0.203284088583955, 5.44040517593633, 2.34117762700245, 
1.38505936277544, 0.942305817848223, 0.694505519016251, 0.539290784663079, 
0.434468421476367, 0.359743186400301, 0.304253023603323, 0.261708393318463, 
0.228238838789949, 1.20135170554199, 0.179336690297472, 4.8455723556124, 
2.08520233734776, 1.23362233916552, 0.83927775116717, 0.618570976781375, 
0.48032682002406, 0.386965327840699, 0.320410260406975, 0.270987176985400, 
0.233094211715109, 0.203284088583955, 0.179336690297472, 1.15972871151143
), .Dim = c(13L, 13L)), structure(c(169.708363605662, 72.6005202900706, 
42.9510470330602, 29.2211457426805, 21.5367947495137, 16.7235459209089, 
13.4729774814976, 11.1557287248254, 9.43496450617895, 8.1156445799142, 
7.07774508667577, 6.24396817013748, 5.56127688584052, 4.99186288885493, 
72.6005202900706, 32.2422895566041, 18.4831877623571, 12.5747789798335, 
9.26796082172822, 7.19666831569057, 5.79784637885196, 4.80066128511737, 
4.06016226716546, 3.49241736686069, 3.04577653882185, 2.68697608191018, 
2.39319252916762, 2.148155759454, 42.9510470330602, 18.4831877623571, 
11.9348013448115, 7.43933956995392, 5.48299956479859, 4.25760639281307, 
3.43005217474436, 2.84010951743920, 2.40202439048816, 2.06614197782306, 
1.80190570051631, 1.58963648758611, 1.41583179388737, 1.27086608594549, 
29.2211457426805, 12.5747789798335, 7.43933956995392, 6.06125090816965, 
3.73028227383396, 2.89660312177248, 2.33358815271847, 1.93222889468527, 
1.63418378923106, 1.40567087485821, 1.22590140931432, 1.08148701115207, 
0.9632414121234, 0.86461601479141, 21.5367947495137, 9.26796082172822, 
5.48299956479859, 3.73028227383396, 3.74932148098385, 2.13487682699919, 
1.71991918173104, 1.42410627839054, 1.20443877052521, 1.03601841569726, 
0.903523334370124, 0.797085918141371, 0.70993563256601, 0.637245979732655, 
16.7235459209089, 7.19666831569057, 4.25760639281307, 2.89660312177248, 
2.13487682699919, 2.65775413969673, 1.33553519687885, 1.10583338978316, 
0.935259277068427, 0.804479113597514, 0.701595299982726, 0.618945535302927, 
0.551272428891733, 0.494828154742676, 13.4729774814976, 5.79784637885196, 
3.43005217474436, 2.33358815271847, 1.71991918173104, 1.33553519687885, 
2.07594619696050, 0.890891706178717, 0.753472214499101, 0.648111891646325, 
0.56522568374531, 0.498640617178190, 0.444121184332248, 0.398648027014641, 
11.1557287248254, 4.80066128511737, 2.84010951743920, 1.93222889468527, 
1.42410627839054, 1.10583338978316, 0.890891706178717, 1.73766516799833, 
0.623880774549554, 0.536641618860344, 0.468011202781713, 0.412878256796512, 
0.367735748104881, 0.330083624957404, 9.43496450617895, 4.06016226716546, 
2.40202439048816, 1.63418378923106, 1.20443877052521, 0.935259277068427, 
0.753472214499101, 0.623880774549554, 1.52764755303375, 0.453864982860186, 
0.395820765784057, 0.349192042432809, 0.311012737635123, 0.279168431069279, 
8.1156445799142, 3.49241736686069, 2.06614197782306, 1.40567087485821, 
1.03601841569726, 0.804479113597514, 0.648111891646325, 0.536641618860344, 
0.453864982860186, 1.39039965500134, 0.340471938219705, 0.300363451782258, 
0.267522875875129, 0.240131456033224, 7.07774508667577, 3.04577653882185, 
1.80190570051631, 1.22590140931432, 0.903523334370124, 0.701595299982726, 
0.56522568374531, 0.468011202781713, 0.395820765784057, 0.340471938219705, 
1.29692941382001, 0.261950350848327, 0.233309714546246, 0.209421348650710, 
6.24396817013748, 2.68697608191018, 1.58963648758611, 1.08148701115207, 
0.797085918141371, 0.618945535302927, 0.498640617178190, 0.412878256796512, 
0.349192042432809, 0.300363451782258, 0.261950350848327, 1.23109191314793, 
0.205825218847325, 0.184750965047323, 5.56127688584052, 2.39319252916762, 
1.41583179388737, 0.9632414121234, 0.70993563256601, 0.551272428891733, 
0.444121184332248, 0.367735748104881, 0.311012737635123, 0.267522875875129, 
0.233309714546246, 0.205825218847325, 1.18332108699290, 0.164551010440494, 
4.99186288885493, 2.148155759454, 1.27086608594549, 0.86461601479141, 
0.637245979732655, 0.494828154742676, 0.398648027014641, 0.330083624957404, 
0.279168431069279, 0.240131456033224, 0.209421348650710, 0.184750965047323, 
0.164551010440494, 1.14770278466675), .Dim = c(14L, 14L)), structure(c(194.223702948996, 
83.1502426237768, 49.1923469346356, 33.4673270734251, 24.6663481419357, 
19.1536767959448, 15.4307619556333, 12.7767892903259, 10.8059774875029, 
9.2949446253555, 8.10622594486867, 7.1512912883777, 6.3693968102166, 
5.71724016156512, 5.29884051697693, 83.1502426237768, 36.7821672127771, 
21.1690156043001, 14.4020444886058, 10.6147061739413, 8.24243013881486, 
6.64034267482875, 5.4982546821593, 4.65015231651012, 3.99990730421356, 
3.48836423167454, 3.07742578486278, 2.74095197459506, 2.46030843688999, 
2.28025789738453, 49.1923469346356, 21.1690156043001, 13.5237585244721, 
8.52036442343422, 6.27974485991968, 4.87628743078538, 3.92847970514082, 
3.25281133674556, 2.75106721080395, 2.36637707367304, 2.06374411070976, 
1.82062964698163, 1.62156905633489, 1.45553810036743, 1.34901876469699, 
33.4673270734251, 14.4020444886058, 8.52036442343422, 6.79671108846964, 
4.27233682190139, 3.31751413623288, 2.67268637066572, 2.21300482084460, 
1.87165020338001, 1.60993163446546, 1.40403951941453, 1.23863998511946, 
1.10321188888621, 0.990255043890387, 0.917786099660839, 24.6663481419357, 
10.6147061739413, 6.27974485991968, 4.27233682190139, 4.14883071472746, 
2.44509991702001, 1.96984397195543, 1.63104592222066, 1.37945810297935, 
1.18656425992184, 1.03481606149584, 0.912912017994389, 0.813097755488148, 
0.729845428298447, 0.676433806751174, 19.1536767959448, 8.24243013881486, 
4.87628743078538, 3.31751413623288, 2.44509991702001, 2.89864560716111, 
1.52960440516647, 1.26652418322296, 1.07116361554524, 0.921379533013388, 
0.803545473010114, 0.708885710814673, 0.631378894131914, 0.566732593093505, 
0.525257911459359, 15.4307619556333, 6.64034267482875, 3.92847970514082, 
2.67268637066572, 1.96984397195543, 1.52960440516647, 2.23229402447727, 
1.02034890692653, 0.862960722534151, 0.742290286935001, 0.647359723495542, 
0.571099051835679, 0.508657294521293, 0.456576344567752, 0.423163128593591, 
12.7767892903259, 5.4982546821593, 3.25281133674556, 2.21300482084460, 
1.63104592222066, 1.26652418322296, 1.02034890692653, 1.84485672346564, 
0.714538099242797, 0.614622052734197, 0.536018817860557, 0.472874396623399, 
0.421172142488611, 0.378048716340917, 0.350382317154572, 10.8059774875029, 
4.65015231651012, 2.75106721080395, 1.87165020338001, 1.37945810297935, 
1.07116361554524, 0.862960722534151, 0.714538099242797, 1.60432104176806, 
0.519816983300907, 0.45333824852733, 0.399933814999827, 0.356206601414431, 
0.319734936933840, 0.296336062617718, 9.2949446253555, 3.99990730421356, 
2.36637707367304, 1.60993163446546, 1.18656425992184, 0.921379533013388, 
0.742290286935001, 0.614622052734197, 0.519816983300907, 1.44712938562838, 
0.389946575540285, 0.344009847191490, 0.306397143540442, 0.275025423385213, 
0.254898485186838, 8.10622594486867, 3.48836423167454, 2.06374411070976, 
1.40403951941453, 1.03481606149584, 0.803545473010114, 0.647359723495542, 
0.536018817860557, 0.45333824852733, 0.389946575540285, 1.34007680251634, 
0.300014864100097, 0.267212401419356, 0.239852770769835, 0.222299841173098, 
7.1512912883777, 3.07742578486278, 1.82062964698163, 1.23863998511946, 
0.912912017994389, 0.708885710814673, 0.571099051835679, 0.472874396623399, 
0.399933814999827, 0.344009847191490, 0.300014864100097, 1.26467232700082, 
0.235734080373908, 0.211597485903456, 0.196112337405947, 6.3693968102166, 
2.74095197459506, 1.62156905633489, 1.10321188888621, 0.813097755488148, 
0.631378894131914, 0.508657294521293, 0.421172142488611, 0.356206601414431, 
0.306397143540442, 0.267212401419356, 0.235734080373908, 1.20995982949724, 
0.188462236736698, 0.174670174370834, 5.71724016156512, 2.46030843688999, 
1.45553810036743, 0.990255043890387, 0.729845428298447, 0.566732593093505, 
0.456576344567752, 0.378048716340917, 0.319734936933840, 0.275025423385213, 
0.239852770769835, 0.211597485903456, 0.188462236736698, 1.16916576261682, 
0.156785856760988, 5.29884051697693, 2.28025789738453, 1.34901876469699, 
0.917786099660839, 0.676433806751174, 0.525257911459359, 0.423163128593591, 
0.350382317154572, 0.296336062617718, 0.254898485186838, 0.222299841173098, 
0.196112337405947, 0.174670174370834, 0.156785856760988, 1.14531193842076
), .Dim = c(15L, 15L)), structure(c(204.036379451817, 87.372946254571, 
51.6905320926518, 35.1669324995374, 25.9190044730623, 20.1263775121080, 
16.2143980880111, 13.4256460203089, 11.3547484703757, 9.7669792842934, 
8.51789268989926, 7.51446261218168, 6.69286038876759, 6.00758460346407, 
5.56793694272373, 3.21107515764815, 87.372946254571, 38.5993295281143, 
22.2440633279379, 15.1334382119898, 11.1537636304940, 8.66101388043088, 
6.97756597373827, 5.77747816097024, 4.8863057473488, 4.20303867898013, 
3.66551739252908, 3.23370983918644, 2.88014853602091, 2.58525279112760, 
2.39605856132245, 1.38182673433241, 51.6905320926518, 22.2440633279379, 
14.1597653348401, 8.95306278547407, 6.59865555198374, 5.12392491191625, 
4.12798369924769, 3.41800217454157, 2.89077746459338, 2.48655121563002, 
2.16854933405414, 1.91308854040213, 1.70391885262773, 1.52945617717919, 
1.41752736137626, 0.817499720673055, 35.1669324995374, 15.1334382119898, 
8.95306278547407, 7.09109138355426, 4.48930326289479, 3.48599084232821, 
2.80841613025823, 2.32539010316094, 1.96670012578552, 1.69169043568685, 
1.47534229123247, 1.30154310358751, 1.15923742413104, 1.04054417639681, 
0.964394967813702, 0.556174531996873, 25.9190044730623, 11.1537636304940, 
6.59865555198374, 4.48930326289479, 4.3087409984773, 2.5692719214719, 
2.06988056872293, 1.71387699186547, 1.44951253163971, 1.24682276369089, 
1.08736818163641, 0.959273360683702, 0.85439012861838, 0.76690991353319, 
0.710785835099234, 0.409916053463574, 20.1263775121080, 8.66101388043088, 
5.12392491191625, 3.48599084232821, 2.5692719214719, 2.99506646470721, 
1.60728386672378, 1.33084337338073, 1.12556161061789, 0.9681708901595, 
0.844352742830608, 0.744885777325835, 0.663442852871287, 0.595513552751955, 
0.551932620033072, 0.318304094158236, 16.2143980880111, 6.97756597373827, 
4.12798369924769, 2.80841613025823, 2.06988056872293, 1.60728386672378, 
2.29487486954961, 1.07216632679204, 0.906785337607922, 0.779986772126583, 
0.680235253001849, 0.600101757824657, 0.53448895702315, 0.479763127036497, 
0.444653053615402, 0.256435083393446, 13.4256460203089, 5.77747816097024, 
3.41800217454157, 2.32539010316094, 1.71387699186547, 1.33084337338073, 
1.07216632679204, 1.88776194467854, 0.750825216764094, 0.645835031695544, 
0.563240008526169, 0.496888859702792, 0.442560957231136, 0.397247550123433, 
0.368176139952049, 0.212330216523696, 11.3547484703757, 4.8863057473488, 
2.89077746459338, 1.96670012578552, 1.44951253163971, 1.12556161061789, 
0.906785337607922, 0.750825216764094, 1.63501089397674, 0.546215379667168, 
0.47636058746019, 0.420244062082548, 0.374296204783495, 0.335972362544143, 
0.311385199313721, 0.179578412661851, 9.7669792842934, 4.20303867898013, 
2.48655121563002, 1.69169043568685, 1.24682276369089, 0.9681708901595, 
0.779986772126583, 0.645835031695544, 0.546215379667168, 1.46983641354014, 
0.409749630448977, 0.361480050343357, 0.321957222376859, 0.288992320140332, 
0.267843255098725, 0.154467414311342, 8.51789268989926, 3.66551739252908, 
2.16854933405414, 1.47534229123247, 1.08736818163641, 0.844352742830608, 
0.680235253001849, 0.563240008526169, 0.47636058746019, 0.409749630448977, 
1.35734726984657, 0.31525082512621, 0.280782521506342, 0.252033458811462, 
0.233589120877234, 0.134712772587334, 7.51446261218168, 3.23370983918644, 
1.91308854040213, 1.30154310358751, 0.959273360683702, 0.744885777325835, 
0.600101757824657, 0.496888859702792, 0.420244062082548, 0.361480050343357, 
0.31525082512621, 1.27811345189632, 0.247705604757796, 0.222343256977561, 
0.206071710380414, 0.118843254997948, 6.69286038876759, 2.88014853602091, 
1.70391885262773, 1.15923742413104, 0.85439012861838, 0.663442852871287, 
0.53448895702315, 0.442560957231136, 0.374296204783495, 0.321957222376859, 
0.280782521506342, 0.247705604757796, 1.22062243379475, 0.198033106841508, 
0.183540628096921, 0.105849394015022, 6.00758460346407, 2.58525279112760, 
1.52945617717919, 1.04054417639681, 0.76690991353319, 0.595513552751955, 
0.479763127036497, 0.397247550123433, 0.335972362544143, 0.288992320140332, 
0.252033458811462, 0.222343256977561, 0.198033106841508, 1.17775668018323, 
0.164748072933914, 0.0950115724568016, 5.56793694272373, 2.39605856132245, 
1.41752736137626, 0.964394967813702, 0.710785835099234, 0.551932620033072, 
0.444653053615402, 0.368176139952049, 0.311385199313721, 0.267843255098725, 
0.233589120877234, 0.206071710380414, 0.183540628096921, 0.164748072933914, 
1.15269146288882, 0.0880584260042643, 3.21107515764815, 1.38182673433241, 
0.817499720673055, 0.556174531996873, 0.409916053463574, 0.318304094158236, 
0.256435083393446, 0.212330216523696, 0.179578412661851, 0.154467414311342, 
0.134712772587334, 0.118843254997948, 0.105849394015022, 0.0950115724568016, 
0.0880584260042643, 1.05078402055781), .Dim = c(16L, 16L)), structure(c(-114.490281610438, 
-49.6991041473369, -29.4023865284223, -20.0035035529712, -14.7431368395068, 
-11.4481996425816, -9.22300430289411, -7.63671832542447, -6.45875927259913, 
-5.55561122135773, -4.84511114776556, -4.2743443592478, -3.80700411012573, 
-3.41720848020366, -3.16712998547596, -1.82650998422218, -13.4604222716588, 
-49.6991041473369, -20.3870891871182, -12.6527725959259, -8.60813734738428, 
-6.34443593891854, -4.92652072886401, -3.96894911856758, -3.28632032156067, 
-2.77940745554879, -2.39075441536906, -2.08500386509110, -1.83938494659137, 
-1.63827372416224, -1.47053239270528, -1.36291574322473, -0.786004750063787, 
-5.79244347678379, -29.4023865284223, -12.6527725959259, -6.48548121549143, 
-5.09264273310051, -3.75341891934068, -2.91456896850537, -2.34806196405088, 
-1.94421332151746, -1.64431962567686, -1.41438938631211, -1.23350492139501, 
-1.08819480958670, -0.969215805869958, -0.869978695887686, -0.806311827456003, 
-0.465006681127265, -3.4268557747748, -20.0035035529712, -8.60813734738428, 
-5.09264273310051, -2.464708448313, -2.55358620689657, -1.98288634361427, 
-1.59747120510386, -1.32271841427272, -1.11868992139981, -0.962260090249116, 
-0.839197867624813, -0.740338159926247, -0.659392454336117, -0.591877870776784, 
-0.548563004901913, -0.316360809320458, -2.33141352658443, -14.7431368395068, 
-6.34443593891854, -3.75341891934068, -2.55358620689657, -0.882063848468242, 
-1.46144222304258, -1.1773805779398, -0.974880151875275, -0.824505494674938, 
-0.709212371131439, -0.618512100395393, -0.545649754324166, -0.485990524583461, 
-0.436230404240456, -0.404306146917881, -0.233166689531036, -1.71831642196528, 
-11.4481996425816, -4.92652072886401, -2.91456896850537, -1.98288634361427, 
-1.46144222304258, -0.134825140512594, -0.914248308096406, -0.757004613587493, 
-0.640237122682769, -0.550710808838492, -0.480281101895801, -0.423702729644989, 
-0.377376715037024, -0.338737462201827, -0.313947943170122, -0.181056368180629, 
-1.33429063719136, -9.22300430289411, -3.96894911856758, -2.34806196405088, 
-1.59747120510386, -1.1773805779398, -0.914248308096406, 0.263454836328712, 
-0.609865046592928, -0.515793742398798, -0.443668726799243, -0.386928495980074, 
-0.341347305311537, -0.304025713672272, -0.272896802028025, -0.252925640811925, 
-0.145864303115853, -1.07494354329344, -7.63671832542447, -3.28632032156067, 
-1.94421332151746, -1.32271841427272, -0.974880151875275, -0.757004613587493, 
-0.609865046592928, 0.49502706228917, -0.427081176084906, -0.367361109796115, 
-0.320379763343788, -0.282638187752866, -0.251735623529173, -0.225960645854106, 
-0.20942437114033, -0.120776762109996, -0.890061501249627, -6.45875927259913, 
-2.77940745554879, -1.64431962567686, -1.11868992139981, -0.824505494674938, 
-0.640237122682769, -0.515793742398798, -0.427081176084906, 0.638795829746987, 
-0.310695887052516, -0.270961384075246, -0.239041423049733, -0.212905560140873, 
-0.191106356744089, -0.177120792121878, -0.102147021659212, -0.752770068164062, 
-5.55561122135773, -2.39075441536906, -1.41438938631211, -0.962260090249116, 
-0.709212371131439, -0.550710808838492, -0.443668726799243, -0.367361109796115, 
-0.310695887052516, 0.732749668522011, -0.233072025506421, -0.205615530199192, 
-0.183134324889012, -0.164383370735693, -0.152353450363554, -0.0878634913931107, 
-0.647507928579529, -4.84511114776556, -2.08500386509110, -1.23350492139501, 
-0.839197867624813, -0.618512100395393, -0.480281101895801, -0.386928495980074, 
-0.320379763343788, -0.270961384075246, -0.233072025506421, 0.79673526025864, 
-0.179319620799233, -0.159713508325989, -0.143360589919778, -0.132869160807945, 
-0.0766267409054455, -0.564698960749193, -4.2743443592478, -1.83938494659137, 
-1.08819480958670, -0.740338159926247, -0.545649754324166, -0.423702729644989, 
-0.341347305311537, -0.282638187752866, -0.239041423049733, -0.205615530199192, 
-0.179319620799233, 0.841804700389767, -0.140898838558883, -0.126472336789350, 
-0.11721682551686, -0.0675999100470134, -0.498175943531151, -3.80700411012573, 
-1.63827372416224, -0.969215805869958, -0.659392454336117, -0.485990524583461, 
-0.377376715037024, -0.304025713672272, -0.251735623529173, -0.212905560140873, 
-0.183134324889012, -0.159713508325989, -0.140898838558883, 0.874506494465035, 
-0.112644341566105, -0.104400792030969, -0.0602087978326573, 
-0.443707316301163, -3.41720848020366, -1.47053239270528, -0.869978695887686, 
-0.591877870776784, -0.436230404240456, -0.338737462201827, -0.272896802028025, 
-0.225960645854106, -0.191106356744089, -0.164383370735693, -0.143360589919778, 
-0.126472336789350, -0.112644341566105, 0.898889208387553, -0.093711291490154, 
-0.0540440747067723, -0.398276534548492, -3.16712998547596, -1.36291574322473, 
-0.806311827456003, -0.548563004901913, -0.404306146917881, -0.313947943170122, 
-0.252925640811925, -0.20942437114033, -0.177120792121878, -0.152353450363554, 
-0.132869160807945, -0.11721682551686, -0.104400792030969, -0.093711291490154, 
0.91314669766989, -0.0500890157954074, -0.36912982113541, -1.82650998422218, 
-0.786004750063787, -0.465006681127265, -0.316360809320458, -0.233166689531036, 
-0.181056368180629, -0.145864303115853, -0.120776762109996, -0.102147021659212, 
-0.0878634913931107, -0.0766267409054455, -0.0675999100470134, 
-0.0602087978326573, -0.0540440747067723, -0.0500890157954074, 
0.97111325147066, -0.212880212327834, -13.4604222716588, -5.79244347678379, 
-3.4268557747748, -2.33141352658443, -1.71831642196528, -1.33429063719136, 
-1.07494354329344, -0.890061501249627, -0.752770068164062, -0.647507928579529, 
-0.564698960749193, -0.498175943531151, -0.443707316301163, -0.398276534548492, 
-0.36912982113541, -0.212880212327834, -0.568815706437707), .Dim = c(17L, 
17L)), structure(c(-0.147488313744484, -0.49380034767778, -0.292136225378409, 
-0.198750806049694, -0.146484855655082, -0.113747019403655, -0.0916379240539453, 
-0.0758769041999714, -0.0641729389109609, -0.0551994407089534, 
-0.0481400542394349, -0.0424690297119616, -0.0378256305710806, 
-0.0339526992400012, -0.0314679693889926, -0.0181478374856014, 
-0.133740060543748, 1.06587386665492, -0.49380034767778, 0.787502164121392, 
-0.125715415079386, -0.0855287290973073, -0.0630370451581924, 
-0.0489489235367877, -0.0394346837491056, -0.0326522207031405, 
-0.0276156359643709, -0.0237540571761934, -0.0207161809283170, 
-0.0182757605337795, -0.0162775596957322, -0.0146109154128127, 
-0.0135416579313926, -0.00780958581682367, -0.0575525585785231, 
0.458679081634688, -0.292136225378409, -0.125715415079386, 0.925625757442486, 
-0.0505994785086786, -0.0372932188446721, -0.0289585736940480, 
-0.0233298735281012, -0.0193173142775157, -0.0163376305626254, 
-0.0140530897426671, -0.0122558579173051, -0.0108120857414663, 
-0.00962993418341185, -0.008643934128632, -0.00801135287175625, 
-0.00462021327652922, -0.0340485528272058, 0.271358204178969, 
-0.198750806049694, -0.0855287290973073, -0.0505994785086786, 
0.965575350587667, -0.0253719212533990, -0.0197015616816650, 
-0.0158721540361568, -0.0131422653195384, -0.0111150790664796, 
-0.0095608235857291, -0.0083381019821821, -0.00735585172092681, 
-0.00655159139774408, -0.0058807800137786, -0.00545041217927562, 
-0.0031432976572564, -0.0231644579869104, 0.184614769150617, 
-0.146484855655082, -0.0630370451581924, -0.0372932188446721, 
-0.0253719212533990, 0.981300190442664, -0.0145205973071465, 
-0.0116982176783742, -0.00968621399116252, -0.00819212150637007, 
-0.00704659211570221, -0.0061454123863624, -0.00542146670484817, 
-0.00482870454356629, -0.00433429795118548, -0.00401710492254439, 
-0.00231669754078399, -0.0170728479143494, 0.136066204451331, 
-0.113747019403655, -0.0489489235367877, -0.0289585736940480, 
-0.0197015616816650, -0.0145205973071465, 0.988724604627131, 
-0.00908378813154157, -0.00752144626742167, -0.00636126785786165, 
-0.00547175232913994, -0.00477197686292545, -0.00420982548479058, 
-0.00374953947939052, -0.00336562759986317, -0.00311932390230896, 
-0.00179893982176863, -0.0132572446093801, 0.105656827995586, 
-0.0916379240539453, -0.0394346837491056, -0.0233298735281012, 
-0.0158721540361568, -0.0116982176783742, -0.00908378813154157, 
0.9926818347304, -0.00605949699115956, -0.00512482334835401, 
-0.00440820363477243, -0.00384444406231091, -0.00339155847843874, 
-0.00302073861672209, -0.00271144798349074, -0.00251301852442438, 
-0.00144927850970620, -0.0106804238128451, 0.0851202293510744, 
-0.0758769041999714, -0.0326522207031405, -0.0193173142775157, 
-0.0131422653195384, -0.00968621399116252, -0.00752144626742167, 
-0.00605949699115956, 0.994982690000402, -0.00424339305215953, 
-0.00365002643111701, -0.00318322917972687, -0.00280823644155891, 
-0.00250119475097721, -0.00224509973365853, -0.00208079861912032, 
-0.00120001372548902, -0.0088434728615772, 0.0704802029795981, 
-0.0641729389109609, -0.0276156359643709, -0.0163376305626254, 
-0.0111150790664796, -0.00819212150637007, -0.00636126785786165, 
-0.00512482334835401, -0.00424339305215953, 0.996411147687394, 
-0.00308701212387567, -0.00269221805823593, -0.00237506771674222, 
-0.00211538701599975, -0.00189879449585052, -0.00175983672605966, 
-0.00101491235455743, -0.00747937267196714, 0.0596086754979071, 
-0.0551994407089534, -0.0237540571761934, -0.0140530897426671, 
-0.0095608235857291, -0.00704659211570221, -0.00547175232913994, 
-0.00440820363477243, -0.00365002643111701, -0.00308701212387567, 
0.997344654217315, -0.00231575697798976, -0.00204295473816408, 
-0.00181958598355893, -0.00163328025754927, -0.00151375337745326, 
-0.000872994057789805, -0.00643350912943617, 0.0512734122002937, 
-0.0481400542394349, -0.0207161809283170, -0.0122558579173051, 
-0.0083381019821821, -0.0061454123863624, -0.00477197686292545, 
-0.00384444406231091, -0.00318322917972687, -0.00269221805823593, 
-0.00231575697798976, 0.997980402245132, -0.00178168384753176, 
-0.00158688143968159, -0.00142440211670237, -0.00132016137772040, 
-0.000761347954851451, -0.00561073580571119, 0.0447161205378424, 
-0.0424690297119616, -0.0182757605337795, -0.0108120857414663, 
-0.00735585172092681, -0.00542146670484817, -0.00420982548479058, 
-0.00339155847843874, -0.00280823644155891, -0.00237506771674222, 
-0.00204295473816408, -0.00178168384753176, 0.998428203178131, 
-0.00139994264809098, -0.00125660381509209, -0.00116464290829702, 
-0.00067165917086235, -0.00494977642637389, 0.0394484443719142, 
-0.0378256305710806, -0.0162775596957322, -0.00962993418341185, 
-0.00655159139774408, -0.00482870454356629, -0.00374953947939052, 
-0.00302073861672209, -0.00250119475097721, -0.00211538701599975, 
-0.00181958598355893, -0.00158688143968159, -0.00139994264809098, 
0.998753121656263, -0.00111921162329961, -0.00103730536570428, 
-0.000598222559804842, -0.00440858705233683, 0.035135304327322, 
-0.0339526992400012, -0.0146109154128127, -0.008643934128632, 
-0.0058807800137786, -0.00433429795118548, -0.00336562759986317, 
-0.00271144798349074, -0.00224509973365853, -0.00189879449585052, 
-0.00163328025754927, -0.00142440211670237, -0.00125660381509209, 
-0.00111921162329961, 0.998995383419705, -0.000931096628663305, 
-0.000536971105173494, -0.00395719590133669, 0.0315378330121886, 
-0.0314679693889926, -0.0135416579313926, -0.00801135287175625, 
-0.00545041217927562, -0.00401710492254439, -0.00311932390230896, 
-0.00251301852442438, -0.00208079861912032, -0.00175983672605966, 
-0.00151375337745326, -0.00132016137772040, -0.00116464290829702, 
-0.00103730536570428, -0.000931096628663305, 0.999137042978473, 
-0.000497674431741953, -0.0036675999928395, 0.0292298281443699, 
-0.0181478374856014, -0.00780958581682367, -0.00462021327652922, 
-0.0031432976572564, -0.00231669754078399, -0.00179893982176863, 
-0.00144927850970620, -0.00120001372548902, -0.00101491235455743, 
-0.000872994057789805, -0.000761347954851451, -0.00067165917086235, 
-0.000598222559804842, -0.000536971105173494, -0.000497674431741953, 
0.999712987050536, -0.00211513516520473, 0.0168570829702674, 
-0.133740060543748, -0.0575525585785231, -0.0340485528272058, 
-0.0231644579869104, -0.0170728479143494, -0.0132572446093801, 
-0.0106804238128451, -0.0088434728615772, -0.00747937267196714, 
-0.00643350912943617, -0.00561073580571119, -0.00494977642637389, 
-0.00440858705233683, -0.00395719590133669, -0.0036675999928395, 
-0.00211513516520473, 0.98441256126097, 0.124227875570478, 1.06587386665492, 
0.458679081634688, 0.271358204178969, 0.184614769150617, 0.136066204451331, 
0.105656827995586, 0.0851202293510744, 0.0704802029795981, 0.0596086754979071, 
0.0512734122002937, 0.0447161205378424, 0.0394484443719142, 0.035135304327322, 
0.0315378330121886, 0.0292298281443699, 0.0168570829702674, 0.124227875570478, 
0.00993579977244408), .Dim = c(18L, 18L)), structure(c(0.986909145830112, 
-0.00563340668751192, -0.00333276834139676, -0.00226740245367209, 
-0.00167113848612564, -0.00129765647757549, -0.00104542999336255, 
-0.00086562405546693, -0.00073210208319699, -0.000629730011125158, 
-0.000549194638612487, -0.000484498071167057, -0.000431524929499496, 
-0.000387341491064548, -0.000358995027103639, -0.000207035393020779, 
-0.00152574244833668, 0.0121597746876762, -0.113760758601671, 
-0.00563340668751192, 0.997575767746317, -0.00143419514255522, 
-0.000975734660246872, -0.000719143502885652, -0.000558422436305338, 
-0.000449881439324319, -0.000372505283433327, -0.000315046575105078, 
-0.000270992649521639, -0.000236335743241396, -0.000208494773433292, 
-0.000185698762824986, -0.000166685238243127, -0.000154486862371520, 
-8.90938476938872e-05, -0.000656575010334409, 0.00523273387322272, 
-0.0489548359462437, -0.00333276834139676, -0.00143419514255522, 
0.99915151871121, -0.000577252409715612, -0.000425451033856926, 
-0.000330367168585526, -0.000266153448797837, -0.000220377097641771, 
-0.000186384067371393, -0.000160321413520357, -0.000139818111261425, 
-0.000123347171399064, -0.000109860869649552, -9.86123168111311e-05, 
-9.13956603230643e-05, -5.27086311140364e-05, -0.000388435014472783, 
0.00309572710777136, -0.0289620715226532, -0.00226740245367209, 
-0.000975734660246872, -0.000577252409715612, 0.999607274374903, 
-0.000289449676445328, -0.000224760694993156, -0.000181073786426028, 
-0.000149930484432251, -0.000126803800442418, -0.000109072437431967, 
-9.51233017321236e-05, -8.39175275430447e-05, -7.47423102625689e-05, 
-6.70895142403269e-05, -6.21797626608056e-05, -3.58595819676972e-05, 
-0.00026426634397836, 0.00210613475676447, -0.0197039413805668, 
-0.00167113848612564, -0.000719143502885652, -0.000425451033856926, 
-0.000289449676445328, 0.999786667561676, -0.000165654865091598, 
-0.000133456401987643, -0.000110502924777389, -9.34579173464037e-05, 
-8.03894110958963e-05, -7.01085112589731e-05, -6.18495449321636e-05, 
-5.5087155356755e-05, -4.94468324672185e-05, -4.58282093998552e-05, 
-2.64295063390904e-05, -0.000194771623932370, 0.00155227972135950, 
-0.0145223512112291, -0.00129765647757549, -0.000558422436305338, 
-0.000330367168585526, -0.000224760694993156, -0.000165654865091598, 
0.999871367268175, -0.000103630289141796, -8.58066745029985e-05, 
-7.25710483195452e-05, -6.24232168088707e-05, -5.44399907749721e-05, 
-4.80268172163228e-05, -4.27757511261853e-05, -3.83959815295955e-05, 
-3.55860829471299e-05, -2.05227875396227e-05, -0.000151242198981189, 
0.00120536140610419, -0.0112767572976958, -0.00104542999336255, 
-0.000449881439324319, -0.000266153448797837, -0.000181073786426028, 
-0.000133456401987643, -0.000103630289141796, 0.999916512409592, 
-6.91283654081814e-05, -5.8465358031245e-05, -5.02899683097141e-05, 
-4.38584480392465e-05, -3.86918079409531e-05, -3.44613955917501e-05, 
-3.09329251687863e-05, -2.86691887276098e-05, -1.65337575946255e-05, 
-0.000121845136836566, 0.000971074385678217, -0.00908488533799608, 
-0.00086562405546693, -0.000372505283433327, -0.000220377097641771, 
-0.000149930484432251, -0.000110502924777389, -8.58066745029985e-05, 
-6.91283654081814e-05, 0.99994276118306, -4.84097650198004e-05, 
-4.16404796054684e-05, -3.63151314762903e-05, -3.20371138343459e-05, 
-2.85342999517672e-05, -2.56126993696976e-05, -2.37383082280997e-05, 
-1.36900781420412e-05, -0.000100888708145964, 0.000804057041817938, 
-0.00752235476278421, -0.00073210208319699, -0.000315046575105078, 
-0.000186384067371393, -0.000126803800442418, -9.34579173464037e-05, 
-7.25710483195452e-05, -5.8465358031245e-05, -4.84097650198004e-05, 
0.999959057411131, -3.52174615203377e-05, -3.07135450285328e-05, 
-2.70954089475854e-05, -2.41329019281796e-05, -2.16619564191054e-05, 
-2.00766889455142e-05, -1.15783921017671e-05, -8.53266876518028e-05, 
0.000680031743118085, -0.00636203621837947, -0.000629730011125158, 
-0.000270992649521639, -0.000160321413520357, -0.000109072437431967, 
-8.03894110958963e-05, -6.24232168088707e-05, -5.02899683097141e-05, 
-4.16404796054684e-05, -3.52174615203377e-05, 0.999969707103771, 
-2.64187761466959e-05, -2.33065750933159e-05, -2.07583244857749e-05, 
-1.86328988400453e-05, -1.72693041628911e-05, -9.95935014310753e-06, 
-7.33951961037987e-05, 0.00058494082586019, -0.00547241324745794, 
-0.000549194638612487, -0.000236335743241396, -0.000139818111261425, 
-9.51233017321236e-05, -7.01085112589731e-05, -5.44399907749721e-05, 
-4.38584480392465e-05, -3.63151314762903e-05, -3.07135450285328e-05, 
-2.64187761466959e-05, 0.999976959887631, -2.03259267615315e-05, 
-1.81035686925521e-05, -1.62499610372355e-05, -1.50607547540609e-05, 
-8.68566148354026e-06, -6.40087775523011e-05, 0.000510133485450369, 
-0.00477255325723793, -0.000484498071167057, -0.000208494773433292, 
-0.000123347171399064, -8.39175275430447e-05, -6.18495449321636e-05, 
-4.80268172163228e-05, -3.86918079409531e-05, -3.20371138343459e-05, 
-2.70954089475854e-05, -2.33065750933159e-05, -2.03259267615315e-05, 
0.99998206852067, -1.59709208650355e-05, -1.43356730483957e-05, 
-1.32865583813744e-05, -7.66246780233875e-06, -5.64683758388496e-05, 
0.000450038424196685, -0.00421033397834277, -0.000431524929499496, 
-0.000185698762824986, -0.000109860869649552, -7.47423102625689e-05, 
-5.5087155356755e-05, -4.27757511261853e-05, -3.44613955917501e-05, 
-2.85342999517672e-05, -2.41329019281796e-05, -2.07583244857749e-05, 
-1.81035686925521e-05, -1.59709208650355e-05, 0.999985775277735, 
-1.27682661081301e-05, -1.18338575734733e-05, -6.82468326495417e-06, 
-5.02943424400313e-05, 0.000400832966797461, -0.00374999237622812, 
-0.000387341491064548, -0.000166685238243127, -9.86123168111311e-05, 
-6.70895142403269e-05, -4.94468324672185e-05, -3.83959815295955e-05, 
-3.09329251687863e-05, -2.56126993696976e-05, -2.16619564191054e-05, 
-1.86328988400453e-05, -1.62499610372355e-05, -1.43356730483957e-05, 
-1.27682661081301e-05, 0.99998853906485, -1.06221998410871e-05, 
-6.12591025727449e-06, -4.51447512323977e-05, 0.000359792050038065, 
-0.00336603412501244, -0.000358995027103639, -0.000154486862371520, 
-9.13956603230643e-05, -6.21797626608056e-05, -4.58282093998552e-05, 
-3.55860829471299e-05, -2.86691887276098e-05, -2.37383082280997e-05, 
-2.00766889455142e-05, -1.72693041628911e-05, -1.50607547540609e-05, 
-1.32865583813744e-05, -1.18338575734733e-05, -1.06221998410871e-05, 
0.999990155155056, -5.67760327663489e-06, -4.18409635066978e-05, 
0.000333461712041493, -0.00311970067709386, -0.000207035393020779, 
-8.90938476938872e-05, -5.27086311140364e-05, -3.58595819676972e-05, 
-2.64295063390904e-05, -2.05227875396227e-05, -1.65337575946255e-05, 
-1.36900781420412e-05, -1.15783921017671e-05, -9.95935014310753e-06, 
-8.68566148354026e-06, -7.66246780233875e-06, -6.82468326495417e-06, 
-6.12591025727449e-06, -5.67760327663489e-06, 0.999996725679363, 
-2.41300287468228e-05, 0.000192310119632831, -0.00179915711089461, 
-0.00152574244833668, -0.000656575010334409, -0.000388435014472783, 
-0.00026426634397836, -0.000194771623932370, -0.000151242198981189, 
-0.000121845136836566, -0.000100888708145964, -8.53266876518028e-05, 
-7.33951961037987e-05, -6.40087775523011e-05, -5.64683758388496e-05, 
-5.02943424400313e-05, -4.51447512323977e-05, -4.18409635066978e-05, 
-2.41300287468228e-05, 0.999822174321977, 0.00141722489322909, 
-0.0132588459164718, 0.0121597746876762, 0.00523273387322272, 
0.00309572710777136, 0.00210613475676447, 0.00155227972135950, 
0.00120536140610419, 0.000971074385678217, 0.000804057041817938, 
0.000680031743118085, 0.00058494082586019, 0.000510133485450369, 
0.000450038424196685, 0.000400832966797461, 0.000359792050038065, 
0.000333461712041493, 0.000192310119632831, 0.00141722489322909, 
0.988705082301263, 0.105669590001036, -0.113760758601671, -0.0489548359462437, 
-0.0289620715226532, -0.0197039413805668, -0.0145223512112291, 
-0.0112767572976958, -0.00908488533799608, -0.00752235476278421, 
-0.00636203621837947, -0.00547241324745794, -0.00477255325723793, 
-0.00421033397834277, -0.00374999237622812, -0.00336603412501244, 
-0.00311970067709386, -0.00179915711089461, -0.0132588459164718, 
0.105669590001036, 0.0114082679649871), .Dim = c(19L, 19L)), 
    structure(c(0.999763537353264, -0.000101757321423337, -6.02004432054978e-05, 
    -4.09565318239572e-05, -3.01860997276412e-05, -2.34398215166044e-05, 
    -1.88838054415657e-05, -1.56359357898275e-05, -1.32241024174084e-05, 
    -1.13749357549555e-05, -9.92020964670435e-06, -8.75158295708061e-06, 
    -7.79471878900636e-06, -6.99662474115785e-06, -6.48459704557545e-06, 
    -3.7397205993177e-06, -2.75597827987093e-05, 0.000219644376833678, 
    -0.00205488272381514, 0.0152378271392533, -0.000101757321423337, 
    0.999956210620975, -2.59061459965776e-05, -1.76248850747334e-05, 
    -1.29900290591234e-05, -1.00868931524314e-05, -8.12629599868944e-06, 
    -6.72863543515227e-06, -5.69074760346267e-06, -4.89499297145799e-06, 
    -4.26897852806357e-06, -3.76608167174732e-06, -3.35431289535463e-06, 
    -3.01086790024080e-06, -2.79052626270884e-06, -1.60931951118070e-06, 
    -1.18598422004994e-05, 9.45198903961047e-05, -0.000884280729749487, 
    0.0065573167491906, -6.02004432054978e-05, -2.59061459965776e-05, 
    0.999984673717341, -1.04270226270085e-05, -7.6850048298557e-06, 
    -5.96748646533859e-06, -4.80758154693301e-06, -3.98071440657522e-06, 
    -3.36669168475682e-06, -2.89591689568574e-06, -2.52556175643633e-06, 
    -2.22804396397264e-06, -1.98443827063980e-06, -1.78125347141982e-06, 
    -1.65089760070204e-06, -9.52086262464392e-07, -7.01637726731266e-06, 
    5.59187212673189e-05, -0.000523147534785553, 0.00387936090512672, 
    -4.09565318239572e-05, -1.76248850747334e-05, -1.04270226270085e-05, 
    0.999992906120598, -5.22838584106146e-06, -4.05989617871041e-06, 
    -3.27077104650367e-06, -2.70822352118653e-06, -2.29048172714453e-06, 
    -1.97019666604143e-06, -1.71823071298265e-06, -1.51581863283172e-06, 
    -1.35008489732705e-06, -1.21185095331786e-06, -1.12316515495475e-06, 
    -6.47738608413005e-07, -4.77349440529263e-06, 3.80435220272727e-05, 
    -0.000355916128124327, 0.00263926908021381, -3.01860997276412e-05, 
    -1.29900290591234e-05, -7.6850048298557e-06, -5.22838584106146e-06, 
    0.999996146534646, -2.99225606946377e-06, -2.41064896364807e-06, 
    -1.99603583737676e-06, -1.68814855069055e-06, -1.45208957877154e-06, 
    -1.26638368405138e-06, -1.11720036785219e-06, -9.95050008791466e-07, 
    -8.93167758664864e-07, -8.27803865908485e-07, -4.77401316963106e-07, 
    -3.51819775138321e-06, 2.80391307262553e-05, -0.000262320056405568, 
    0.00194521450219113, -2.34398215166044e-05, -1.00868931524314e-05, 
    -5.96748646533859e-06, -4.05989617871041e-06, -2.99225606946377e-06, 
    0.99999767648193, -1.87189408227378e-06, -1.54994266205298e-06, 
    -1.31086497025871e-06, -1.12756271461459e-06, -9.8336014899344e-07, 
    -8.67517746811155e-07, -7.7266671801293e-07, -6.93554087357608e-07, 
    -6.42798342373534e-07, -3.70707105666926e-07, -2.73191727638227e-06, 
    2.17726776772800e-05, -0.000203694261857279, 0.00151047936481568, 
    -1.88838054415657e-05, -8.12629599868944e-06, -4.80758154693301e-06, 
    -3.27077104650367e-06, -2.41064896364807e-06, -1.87189408227378e-06, 
    0.999998491947405, -1.24867911878328e-06, -1.05607114119849e-06, 
    -9.08397485486921e-07, -7.92223683078252e-07, -6.98897657402491e-07, 
    -6.22482895776034e-07, -5.58747447781805e-07, -5.17857135855069e-07, 
    -2.98652481387763e-07, -2.20091242133009e-06, 1.75407056281731e-05, 
    -0.000164102052046403, 0.00121688633287901, -1.56359357898275e-05, 
    -6.72863543515227e-06, -3.98071440657522e-06, -2.70822352118653e-06, 
    -1.99603583737676e-06, -1.54994266205298e-06, -1.24867911878328e-06, 
    0.99999896608411, -8.7443500751829e-07, -7.52160087576957e-07, 
    -6.55967287850068e-07, -5.78692622555433e-07, -5.15420613643696e-07, 
    -4.62647173700278e-07, -4.2878968169789e-07, -2.47286545971983e-07, 
    -1.82237237115369e-06, 1.45238388395322e-05, -0.000135877758151894, 
    0.00100759122006911, -1.32241024174084e-05, -5.69074760346267e-06, 
    -3.36669168475682e-06, -2.29048172714453e-06, -1.68814855069055e-06, 
    -1.31086497025871e-06, -1.05607114119849e-06, -8.7443500751829e-07, 
    0.999999260446049, -6.36139861796803e-07, -5.54784741610571e-07, 
    -4.89429645384605e-07, -4.35917304501986e-07, -3.91284134852828e-07, 
    -3.62649139937623e-07, -2.09142750030233e-07, -1.54127256614026e-06, 
    1.22835457301418e-05, -0.000114918698452158, 0.000852170900941155, 
    -1.13749357549555e-05, -4.89499297145799e-06, -2.89591689568574e-06, 
    -1.97019666604143e-06, -1.45208957877154e-06, -1.12756271461459e-06, 
    -9.08397485486921e-07, -7.52160087576957e-07, -6.36139861796803e-07, 
    0.99999945281352, -4.77207495409472e-07, -4.2099120205631e-07, 
    -3.74961655367699e-07, -3.36569678258473e-07, -3.11938802209363e-07, 
    -1.79897680017729e-07, -1.32575171208910e-06, 1.05658999842201e-05, 
    -9.88492655815788e-05, 0.00073300923907604, -9.92020964670435e-06, 
    -4.26897852806357e-06, -2.52556175643633e-06, -1.71823071298265e-06, 
    -1.26638368405138e-06, -9.8336014899344e-07, -7.92223683078252e-07, 
    -6.55967287850068e-07, -5.54784741610571e-07, -4.77207495409472e-07, 
    0.999999583821966, -3.67151171117363e-07, -3.27008284781072e-07, 
    -2.93526208936462e-07, -2.72045344388922e-07, -1.56890793862650e-07, 
    -1.15620300691998e-06, 9.2146404346865e-06, -8.62075583648741e-05, 
    0.000639265617077238, -8.75158295708061e-06, -3.76608167174732e-06, 
    -2.22804396397264e-06, -1.51581863283172e-06, -1.11720036785219e-06, 
    -8.67517746811155e-07, -6.98897657402491e-07, -5.78692622555433e-07, 
    -4.89429645384605e-07, -4.2099120205631e-07, -3.67151171117363e-07, 
    0.9999996761002, -2.88485851996580e-07, -2.58948052417241e-07, 
    -2.39997689998231e-07, -1.38408647255491e-07, -1.01999926318572e-06, 
    8.12913164699287e-06, -7.60520821057654e-05, 0.00056395845236188, 
    -7.79471878900636e-06, -3.35431289535463e-06, -1.98443827063980e-06, 
    -1.35008489732705e-06, -9.95050008791466e-07, -7.7266671801293e-07, 
    -6.22482895776034e-07, -5.15420613643696e-07, -4.35917304501986e-07, 
    -3.74961655367699e-07, -3.27008284781072e-07, -2.88485851996580e-07, 
    0.999999743056073, -2.30635675791684e-07, -2.13757272566765e-07, 
    -1.23275582099174e-07, -9.08476496254175e-07, 7.24032389315988e-06, 
    -6.77368421507386e-05, 0.00050229742052408, -6.99662474115785e-06, 
    -3.01086790024080e-06, -1.78125347141982e-06, -1.21185095331786e-06, 
    -8.93167758664864e-07, -6.93554087357608e-07, -5.58747447781805e-07, 
    -4.62647173700278e-07, -3.91284134852828e-07, -3.36569678258473e-07, 
    -2.93526208936462e-07, -2.58948052417241e-07, -2.30635675791684e-07, 
    0.999999792978898, -1.91870863122402e-07, -1.10653509259655e-07, 
    -8.15458428008617e-07, 6.4989938259641e-06, -6.08013295294488e-05, 
    0.000450867652187174, -6.48459704557545e-06, -2.79052626270884e-06, 
    -1.65089760070204e-06, -1.12316515495475e-06, -8.27803865908485e-07, 
    -6.42798342373534e-07, -5.17857135855069e-07, -4.2878968169789e-07, 
    -3.62649139937623e-07, -3.11938802209363e-07, -2.72045344388922e-07, 
    -2.39997689998231e-07, -2.13757272566765e-07, -1.91870863122402e-07, 
    0.99999982217065, -1.02555653014623e-07, -7.55781467304933e-07, 
    6.023383806073e-06, -5.63517605159536e-05, 0.000417872210313034, 
    -3.7397205993177e-06, -1.60931951118070e-06, -9.52086262464392e-07, 
    -6.47738608413005e-07, -4.77401316963106e-07, -3.70707105666926e-07, 
    -2.98652481387763e-07, -2.47286545971983e-07, -2.09142750030233e-07, 
    -1.79897680017729e-07, -1.56890793862650e-07, -1.38408647255491e-07, 
    -1.23275582099174e-07, -1.10653509259655e-07, -1.02555653014623e-07, 
    0.99999994085531, -4.35865405667931e-07, 3.47373512013943e-06, 
    -3.2498525063037e-05, 0.0002409903501801, -2.75597827987093e-05, 
    -1.18598422004994e-05, -7.01637726731266e-06, -4.77349440529263e-06, 
    -3.51819775138321e-06, -2.73191727638227e-06, -2.20091242133009e-06, 
    -1.82237237115369e-06, -1.54127256614026e-06, -1.32575171208910e-06, 
    -1.15620300691998e-06, -1.01999926318572e-06, -9.08476496254175e-07, 
    -8.15458428008617e-07, -7.55781467304933e-07, -4.35865405667931e-07, 
    0.999996787900168, 2.55996090800895e-05, -0.000239497114351035, 
    0.00177597270468821, 0.000219644376833678, 9.45198903961047e-05, 
    5.59187212673189e-05, 3.80435220272727e-05, 2.80391307262553e-05, 
    2.17726776772800e-05, 1.75407056281731e-05, 1.45238388395322e-05, 
    1.22835457301418e-05, 1.05658999842201e-05, 9.2146404346865e-06, 
    8.12913164699287e-06, 7.24032389315988e-06, 6.4989938259641e-06, 
    6.023383806073e-06, 3.47373512013943e-06, 2.55996090800895e-05, 
    0.999795977703284, 0.00190873037060222, -0.0141540454380189, 
    -0.00205488272381514, -0.000884280729749487, -0.000523147534785553, 
    -0.000355916128124327, -0.000262320056405568, -0.000203694261857279, 
    -0.000164102052046403, -0.000135877758151894, -0.000114918698452158, 
    -9.88492655815788e-05, -8.62075583648741e-05, -7.60520821057654e-05, 
    -6.77368421507386e-05, -6.08013295294488e-05, -5.63517605159536e-05, 
    -3.2498525063037e-05, -0.000239497114351035, 0.00190873037060222, 
    0.982142875135193, 0.132418156394250, 0.0152378271392533, 
    0.0065573167491906, 0.00387936090512672, 0.00263926908021381, 
    0.00194521450219113, 0.00151047936481568, 0.00121688633287901, 
    0.00100759122006911, 0.000852170900941155, 0.00073300923907604, 
    0.000639265617077238, 0.00056395845236188, 0.00050229742052408, 
    0.000450867652187174, 0.000417872210313034, 0.0002409903501801, 
    0.00177597270468821, -0.0141540454380189, 0.132418156394250, 
    0.0180631946294437), .Dim = c(20L, 20L)))
