% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-custom_thresholds.R
\name{thresholds}
\alias{thresholds}
\alias{thresholds<-}
\alias{set_thresholds}
\title{Get/set the thresholds}
\usage{
thresholds(plate)

thresholds(plate) <- value

set_thresholds(plate, value)
}
\arguments{
\item{plate}{A ddPCR plate.}

\item{value}{The new thresholds as a 2-element numeric vector}
}
\value{
The current thresholds
}
\description{
For ddPCR plates of type \code{custom_thresholds}, get or set the thresholds
that divide the four droplet quadrants.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
thresholds(plate)
thresholds(plate) <- c(5500, 8000)
set_thresholds(plate, c(5500, 8000))
}
}
\seealso{
\code{\link[ddpcr]{custom_thresholds}}\cr
\code{\link[ddpcr]{x_threshold}}\cr
\code{\link[ddpcr]{y_threshold}}
}
