% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-extend.R
\name{define_params}
\alias{define_params}
\title{Define plate type parameters}
\usage{
define_params(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
A list of default parameters for the plate type.
}
\description{
Every ddPCR plate type has a set of default parameters. When creating a
custom plate type, if your plate type needs a different set of parameters
than its parent type, you must define this function to return the parameters
specific to this plate. When defining this function, you can use
\code{NextMethod("define_params")} to get a list of the parameters of the
parent type so that you can simply add to that list rather than redefining
all the parameters.
}
\seealso{
\code{\link[ddpcr]{params}}

\code{\link[ddpcr]{params}}\cr
\code{\link[ddpcr]{parent_plate_type}}\cr
\code{\link[ddpcr]{define_clusters}}\cr
\code{\link[ddpcr]{define_steps}}
}
\keyword{internal}
