% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/failures.R
\name{wells_success}
\alias{wells_failed}
\alias{wells_success}
\title{Get successful/failed wells}
\usage{
wells_success(plate)

wells_failed(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
List of wells that had a successful/failed ddPCR run.
}
\description{
Get a list of wells that had successful or failed ddPCR runs. One of the analysis steps
for ddPCR plates includes identifying failed wells, which are wells where
the ddPCR run was not successful and did not produce useful droplet data.
}
\examples{
\dontrun{
dir <- sample_data_dir()
plate <- new_plate(dir) \%>\% analyze
plate \%>\% wells_success
plate \%>\% wells_failed
} 
}
\seealso{
\code{\link[ddpcr]{remove_failures}}
}

