% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/model.R
\name{compartmentalModel}
\alias{compartmentalModel}
\title{Compartmental Models for Kinetic Parameter Estimation}
\usage{
compartmentalModel(type)
}
\arguments{
\item{type}{is a character string that identifies the type of compartmental
model to be used.  Acceptable models include:
\describe{
\item{"weinmann"}{Weinmann AIF convolved with a single compartment
(Kety) model}
\item{"extended"}{Kety model extended with additional vascular
compartment (default)}
\item{"orton.exp"}{Extended model using Orton's exponential arterial
input function}
\item{"orton.cos"}{Extended model using Orton's raised cosine arterial
input function}
\item{"kety.orton.exp"}{Kety model using Orton's exponential arterial
input function}
\item{"kety.orton.cos"}{Kety model using Orton's raised cosine
arterial input function}
\item{"weinmann.empirical"}{User-specified empirical AIF convolved
with a single compartment model}
\item{"extended.empirical"}{Extended model with user-specified
empirical arterial input function}
}}
}
\value{
A function.
}
\description{
A selection of parametric models are provided that combine a compartmental
model for tissue and a functional form of the arterial input function.
}
\details{
Parametric models from the DCE-MRI literature are provided to the user for
kinetic parameter estimation.  All models, with the exception of those
marked \sQuote{empirical} incorporate a parametric model for the arterial
input function (AIF).
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\seealso{
\code{\link{aifParameters}}, \code{\link{dcemri.bayes}},
\code{\link{dcemri.lm}}, \code{\link{dcemri.map}}
}
\keyword{misc}

