% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-postgres.R
\name{backend-postgres}
\alias{simulate_postgres}
\title{Backend: PostgreSQL}
\usage{
simulate_postgres()
}
\description{
See \code{vignette("translate-function")} and \code{vignette("translate-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item Many stringr functions
\item lubridate date-time extraction functions
\item More standard statistical summaries
}

Use \code{simulate_postgres()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_postgres())
lf \%>\% summarise(x = sd(b, na.rm = TRUE))
lf \%>\% summarise(y = cor(b, c), y = cov(b, c))
}
