% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{felid_gdr_phylo_all}
\alias{felid_gdr_phylo_all}
\title{datelifeSummary of a datelifeResult object of all Felidae species.}
\format{
A list of three elements, containing the summary of a datelifeResult object
\describe{
\item{phylo_all}{List of subset chronograms in phylo format}
\item{taxon_distribution}{A data frame with taxon presence across subset chronograms}
\item{absent_taxa}{A dataframe with names of taxon not found in any chronogram}
}
}
\source{
\url{http://opentreeoflife.org}
}
\usage{
felid_gdr_phylo_all
}
\description{
datelifeSummary of a datelifeResult object of all Felidae species.
}
\details{
Generated with:
felid_spp <- make_datelife_query(input = "felidae", get_spp_from_taxon = TRUE)
felid_gdr <- get_datelife_result(input = felid_spp, get_spp_from_taxon = TRUE)
felid_gdr_phylo_all <- summarize_datelife_result(datelife_result = felid_gdr, taxon_summary = "summary", summary_format = "phylo_all", datelife_query = felid_spp)
usethis::use_data(felid_gdr_phylo_all)
}
\keyword{chronogram}
\keyword{felidae}
\keyword{otol}
\keyword{subset}
\keyword{tree}
