% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_date.R
\name{fix_date}
\alias{fix_date}
\title{Convert improperly formatted date to R's Date class}
\usage{
fix_date(date, day.impute = 1, month.impute = 7, format = "dmy")
}
\arguments{
\item{date}{Character to be converted to \R{}'s date class.}

\item{day.impute}{Integer. Day of the month to be imputed if not available.
defaults to 1. If \code{day.impute = NA} then \code{NA} will be imputed for
the date instead and a warning will be raised. If \code{day.impute = NULL}
then instead of imputing the day of the month, the function will fail}

\item{month.impute}{Integer. Month to be be imputed if not available.
Defaults to 7 (July). If \code{month.impute = NA} then \code{NA} will be
imputed for the date instead and a warning will be raised. If
\code{month.impute = NULL} then instead of imputing the month, the
function will fail.}

\item{format}{Character. The format which a date is mostly likely to be given
in. Either \code{"dmy"} (default) or \code{"mdy"}. If year appears to have
been given first, then YMD is assumed for the subject (format argument is
not used for these observations)}
}
\value{
An object belonging to \R's built in \code{Date} class.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Converts a single improperly formatted date to \R{}'s Date class.
Supports numerous separators including /,- or white space.
Supports all-numeric, abbreviation or long-hand month notation. Where
day of the month has not been supplied, the first day of the month is
imputed. Either DMY or YMD is assumed by default. However, the US system of
MDY is supported via the \code{format} argument.
}
\examples{
bad.date <- "02 03 2021"
fixed.date <- fix_date(bad.date)
fixed.date
# ->
fixed.date <- fix_date_char(bad.date)
}
\seealso{
\code{\link{fix_dates}} Similar to \code{fix_date()} except is
applicable to columns of a dataframe.
}
\keyword{internal}
