% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_date_char.R
\name{fix_date_char}
\alias{fix_date_char}
\title{Convert improperly formatted date to \R{}'s Date class}
\usage{
fix_date_char(dates, day.impute = 1, month.impute = 7, format = "dmy")
}
\arguments{
\item{dates}{Character vector to be converted to \R{}'s date class.}

\item{day.impute}{Integer. Day of the month to be imputed if not available.
defaults to 1. If \code{day.impute = NA} then \code{NA} will be imputed for
the date instead and a warning will be raised. If \code{day.impute = NULL}
then instead of imputing the day of the month, the function will fail}

\item{month.impute}{Integer. Month to be be imputed if not available.
Defaults to 7 (July). If \code{month.impute = NA} then \code{NA} will be
imputed for the date instead and a warning will be raised. If
\code{month.impute = NULL} then instead of imputing the month, the
function will fail.}

\item{format}{Character. The format which a date is mostly likely to be given
in. Either \code{"dmy"} (default) or \code{"mdy"}. If year appears to have
been given first, then YMD is assumed for the subject (format argument is
not used for these observations)}
}
\value{
A vector of elements belonging to \R{}'s built in \code{Date} class
with the following format \code{yyyy-mm-dd}.
}
\description{
Converts a character vector (or single character object)  from improperly
formatted dates to \R{}'s Date class. Supports numerous separators including
/, -, or white space. Supports all-numeric, abbreviation or long-hand month
notation. Where day of the month has not been supplied, the first day of the
month is imputed by default. Either DMY or YMD is assumed by default.
However, the US system of MDY is supported via the \code{format} argument.
}
\examples{
bad.date <- "02 03 2021"
fixed.date <- fix_date_char(bad.date)
fixed.date
}
\seealso{
\code{\link{fix_date_df}} which is similar to \code{fix_date_char()}
except is applicable to columns of a data frame.
}
