% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tabulate.R
\name{data_tabulate}
\alias{data_tabulate}
\alias{data_tabulate.default}
\alias{data_tabulate.data.frame}
\title{Create frequency tables of variables}
\usage{
data_tabulate(x, ...)

\method{data_tabulate}{default}(x, drop_levels = FALSE, name = NULL, verbose = TRUE, ...)

\method{data_tabulate}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  collapse = FALSE,
  drop_levels = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A (grouped) data frame, a vector or factor.}

\item{...}{not used.}

\item{drop_levels}{Logical, if \code{TRUE}, factor levels that do not occur in
the data are included in the table (with frequency of zero), else unused
factor levels are dropped from the frequency table.}

\item{name}{Optional character string, which includes the name that is used
for printing.}

\item{verbose}{Toggle warnings.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")},
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{collapse}{Logical, if \code{TRUE} collapses multiple tables into one larger
table for printing. This affects only printing, not the returned object.}
}
\value{
A data frame, or a list of data frames, with one frequency table
as data frame per variable.
}
\description{
This function creates frequency tables of variables, including
the number of levels/values as well as the distribution of raw, valid and
cumulative percentages.
}
\section{Selection of variables - the \code{select} argument}{

For most functions that have a \code{select} argument (including this function),
the complete input data frame is returned, even when \code{select} only selects
a range of variables. That is, the function is only applied to those variables
that have a match in \code{select}, while all other variables remain unchanged.
In other words: for this function, \code{select} will not omit any non-included
variables, so that the returned data frame will include all variables
from the input data frame.
}

\examples{
data(efc)

# vector/factor
data_tabulate(efc$c172code)

# data frame
data_tabulate(efc, c("e42dep", "c172code"))

# grouped data frame
if (requireNamespace("poorman")) {
  suppressPackageStartupMessages(library(poorman, quietly = TRUE))
  efc \%>\%
    group_by(c172code) \%>\%
    data_tabulate("e16sex")

  # collapse tables
  efc \%>\%
    group_by(c172code) \%>\%
    data_tabulate("e16sex", collapse = TRUE)
}

# for larger N's (> 100000), a big mark is automatically added
set.seed(123)
x <- sample(1:3, 1e6, TRUE)
data_tabulate(x, name = "Large Number")

# to remove the big mark, use "print(..., big_mark = "")"
print(data_tabulate(x), big_mark = "")
}
