% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{Get metadata}
\usage{
get_metadata(destination, verbose = FALSE)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{verbose}{TRUE /FALSE should the function be chatty?}
}
\value{
a list
}
\description{
Read versioned dataset metadata to a list
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
md <- generate_metadata(df, temp_dir)
put_metadata(md, temp_dir)

get_metadata(temp_dir)

unlink(temp_dir)

}
