% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_factor.R
\name{as_factor}
\alias{as_factor}
\title{Coerce a defined vector to a factor}
\usage{
as_factor(x, ...)
}
\arguments{
\item{x}{A vector created with \code{\link[=defined]{defined()}}.}

\item{...}{Reserved for future extensions; not used.}
}
\value{
A factor vector with levels derived from the value labels.
}
\description{
Converts a \code{\link[=defined]{defined()}} vector with value labels into a
factor using \code{\link[haven:as_factor]{haven::as_factor()}}. This allows categorical \code{defined}
vectors to behave like standard factors in models and plotting.
}
\examples{
sex <- defined(
  c(0, 1, 1, 0),
  label = "Sex",
  labels = c("Female" = 0, "Male" = 1)
)
as_factor(sex)

}
