% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_uri.R
\name{dataset_uri}
\alias{dataset_uri}
\title{Create a globally unique row identifier}
\usage{
dataset_uri(
  ds,
  prefix = "https:://example.org/my_data/",
  keep_local_id = FALSE
)
}
\arguments{
\item{ds}{A dataset object.}

\item{prefix}{The prefix of the globally unique wor identifier (URI or CURIe),
defaults to \code{"https:://example.org/my_data/"}.}

\item{keep_local_id}{Defaults to \code{FALSE}.}
}
\value{
A dataset object with a locally unique row identifier added as a primary key to
the tabular form.
}
\description{
Add a globally unique row identifier to a dataset object.
}
\examples{
my_ds <- dataset (x = data.frame (
   time = rep(c(2019:2022),4),
   geo = c(rep("NL",8), rep("BE",8)),
   sex = c(rep("F", 4), rep("M", 4), rep("F", 4), rep("M", 4)),
   value = c(1,3,2,4,2,3,1,5, NA_real_, 4,3,2,1, NA_real_, 2,5),
   unit = rep("NR",8),
   freq = rep("A",8)),
 Dimensions = c("time", "geo", "sex"),
 Measures = "value",
 Attributes = c("unit", "freq"),
 sdmx_attributes = c("sex", "time", "freq"),
 Title = "Example dataset",
 Creator = person("Jane", "Doe"),
 Publisher = "Publishing Co.",
 Issued = as.Date("2022-07-14")
)
dataset_uri(my_ds)
}
\seealso{
Other dataset functions: 
\code{\link{dataset_local_id}()},
\code{\link{dataset}()}
}
\concept{dataset functions}
