% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdvancedTuning.R
\name{StartTuningSession}
\alias{StartTuningSession}
\title{Create a function to initiate hyperparameter tuning for a particular model.}
\usage{
StartTuningSession(model)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object to get tuning parameters for.}
}
\value{
A function that can be used to tune the model. The function will take \code{model},
  the model object to tune, and will have individual arguments for each tunable hyperparameter
  that are each set to the default value for that hyperparameter. Furthermore, the function
  takes \code{tuningDescription} which can be used to describe the hyperparameter tuning
  taking place for future reference. The function itself will return a job ID that can be used
  to get the tuned model.
}
\description{
The advanced tuning feature allows you to manually set model parameters and override the
DataRobot default selections.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  myXGBModel <- GetModel(projectId, modelId)
  RunTune <- StartTuningSession(myXGBModel)
  tuningJob <- RunTune(myXGBModel, colsample_bytree = 0.4, colsample_bylevel = 0.8)
  tunedModel <- GetModelFromJobId(projectId, tuningJob)
}
}
\seealso{
RunInteractiveTuning
}
