% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComplianceDocumentation.R
\name{GetComplianceDocTemplate}
\alias{GetComplianceDocTemplate}
\title{Get a compliance doc template.}
\usage{
GetComplianceDocTemplate(templateId = NULL, type = NULL)
}
\arguments{
\item{templateId}{character. Optional. The ID of the template to use in generating custom
model documentation.}

\item{type}{character. Optional. The type of compliance doc to get. Can be "normal" to retrieve
the default template or "timeSeries" to get the default time series template.}
}
\value{
An S3 object of class 'dataRobotComplianceDocTemplate' that contains:
 \itemize{
   \item name character. The name of the compliance doc template.
   \item creatorUsername character. The name of the user who created the compliance doc template.
   \item orgId character. The ID of the organization of the creator user.
   \item creatorId character. The ID of the creator user.
   \item sections list. The list of sections that define the template.
   \item id character. The ID of the template.
 }
}
\description{
A custom compliance doc template can be retrieved using \code{templateId}. Default compliance
doc templates that are built-in to DataRobot can be retrieved by using the \code{type}
parameter. A type of NULL or "normal" will retrieve the default template. A type of "timeSeries"
can be used to retrieve the default time series template.
}
\examples{
\dontrun{
  GetComplianceDocTemplate()  # get the default template
  GetComplianceDocTemplate(type = "normal")  # get the default template
  GetComplianceDocTemplate(type = "timeSeries")  # get the default time series template
  templateId <- "5cf85080d9436e5c310c796d"
  GetComplianceDocTemplate(templateId) # Get a custom template for a specific ID.
}
}
