% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_observations_in_subgroups.R
\name{util_observations_in_subgroups}
\alias{util_observations_in_subgroups}
\title{Utility function observations in subgroups}
\usage{
util_observations_in_subgroups(x, rvs)
}
\arguments{
\item{x}{data frame}

\item{rvs}{variable names}
}
\value{
matrix of flags
}
\description{
This function uses \code{!is.na} to count the number of non-missing observations in subgroups of
the data (list) and in a set of user defined response variables. In some applications it is
required that the number of observations per e.g. factor level is higher than a user-defined
minimum number.
}
\seealso{
\link{prep_min_obs_level}

\link{util_check_group_levels}

Other robustness_functions: 
\code{\link{util_as_valid_missing_codes}()},
\code{\link{util_check_one_unique_value}()},
\code{\link{util_correct_variable_use}()},
\code{\link{util_empty}()},
\code{\link{util_ensure_character}()},
\code{\link{util_ensure_in}()},
\code{\link{util_ensure_suggested}()},
\code{\link{util_expect_scalar}()},
\code{\link{util_fix_rstudio_bugs}()},
\code{\link{util_is_integer}()},
\code{\link{util_is_numeric_in}()},
\code{\link{util_is_valid_missing_codes}()},
\code{\link{util_match_arg}()},
\code{\link{util_stop_if_not}()},
\code{\link{util_warn_unordered}()}
}
\concept{data_management}
\concept{robustness_functions}
\keyword{internal}
