% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_map_labels.R
\name{util_map_labels}
\alias{util_map_labels}
\title{Support function to allocate labels to variables}
\usage{
util_map_labels(
  x,
  meta_data = "item_level",
  to = LABEL,
  from = VAR_NAMES,
  ifnotfound,
  warn_ambiguous = FALSE
)
}
\arguments{
\item{x}{\link{character} variable names, character vector, see parameter from}

\item{meta_data}{\link{data.frame} metadata data frame, if, as a \code{dataquieR}
developer, you do not have
\strong{item-level-metadata}, you should use
\link{util_map_labels} instead to avoid consistency
checks on for item-level \code{meta_data}.}

\item{to}{\link{character} variable attribute to map to}

\item{from}{\link{character} variable identifier to map from}

\item{ifnotfound}{\link{list} A list of values to be used if the item is not
found: it will be coerced to a list if necessary.}

\item{warn_ambiguous}{\link{logical} print a warning if mapping variables from
\code{from} to \code{to} produces ambiguous identifiers.}
}
\value{
a character vector with:
\itemize{
\item mapped values
}
}
\description{
Map variables to certain attributes, e.g. by default their labels.
}
\details{
This function basically calls \code{colnames(study_data) <- meta_data$LABEL},
ensuring correct merging/joining of study data columns to the corresponding
metadata rows, even if the orders differ. If a variable/study_data-column
name is not found in \code{meta_data[[from]]} (default \code{from = VAR_NAMES}),
either stop is called or, if \code{ifnotfound} has been assigned a value, that
value is returned. See \code{\link{mget}}, which is internally used by this function.

The function not only maps to the \code{LABEL} column, but \code{to} can be any
metadata variable attribute, so the function can also be used, to get, e.g.
all \code{HARD_LIMITS} from the metadata.
}
\examples{
\dontrun{
meta_data <- prep_create_meta(
  VAR_NAMES = c("ID", "SEX", "AGE", "DOE"),
  LABEL = c("Pseudo-ID", "Gender", "Age", "Examination Date"),
  DATA_TYPE = c(DATA_TYPES$INTEGER, DATA_TYPES$INTEGER, DATA_TYPES$INTEGER,
                 DATA_TYPES$DATETIME),
  MISSING_LIST = ""
)
stopifnot(all(prep_map_labels(c("AGE", "DOE"), meta_data) == c("Age",
                                                 "Examination Date")))
}
}
\seealso{
Other mapping: 
\code{\link{util_map_all}()},
\code{\link{util_map_by_largest_prefix}()},
\code{\link{util_recode}()}
}
\concept{mapping}
\concept{metadata_management}
\keyword{internal}
