% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_get_labels.R
\name{prep_get_labels}
\alias{prep_get_labels}
\title{Fetch a label for a variable based on its purpose}
\usage{
prep_get_labels(
  resp_vars,
  meta_data = "item_level",
  label_col,
  max_len = MAX_LABEL_LEN,
  label_class = c("SHORT", "LONG"),
  label_lang = "",
  resp_vars_are_var_names_only = FALSE
)
}
\arguments{
\item{resp_vars}{\link{variable list} the variable names to fetch for}

\item{meta_data}{\link{meta_data} the metadata, item-level}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{max_len}{\link{integer} the maximum label length to return, if not possible
w/o causing ambiguous labels, the labels may still
be longer}

\item{label_class}{\link{enum} SHORT | LONG. which sort of label
according to the metadata model should be returned}

\item{label_lang}{\link{character} optional language suffix, if available in
the metadata}

\item{resp_vars_are_var_names_only}{\link{logical} If \code{TRUE}, do not use
other labels than \link{VAR_NAMES}
for finding \code{resp_vars} in
\code{meta_data}}
}
\value{
\link{character} suitable labels for each \code{resp_vars}, names of this
vector are \link{VAR_NAMES}
}
\description{
Fetch a label for a variable based on its purpose
}
\examples{
\dontrun{
prep_load_workbook_like_file("meta_data_v2")
prep_get_labels("SEX_0", label_class = "SHORT", max_len = 2)
}
}
