% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_ensure_data_type.R
\name{util_ensure_data_type}
\alias{util_ensure_data_type}
\title{Ensure matching data types}
\usage{
util_ensure_data_type(variables, study_data, meta_data, label_col)
}
\arguments{
\item{variables}{\link{variable list} the names of the variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
the transformed (if necessary and possible) study data
}
\description{
Utility function to convert selected variables in the study data to match the
data types given in the metadata. If such a conversion is not possible, the
study data remains unchanged.
}
\examples{
\dontrun{
load(system.file("extdata/meta_data.RData", package = "dataquieR"), envir =
  environment())
load(system.file("extdata/study_data.RData", package = "dataquieR"), envir =
  environment())
study_data$v00000 <- as.character(study_data$v00000)
sd1 <-
  util_ensure_data_type(
    c("CENTER_0", "AGE_0", "v00000", "v003"),
    study_data = study_data,
    meta_data = meta_data,
    label_col = "LABEL"
  )
all.equal(study_data, sd1)
study_data$v00013 <- as.numeric(study_data$v00013)
Sys.setenv(TZ = 'CET')
sd2 <-
  util_ensure_data_type(
    c("CENTER_0", "AGE_0", "v00000", "EXAM_DT_0"),
    study_data = study_data,
    meta_data = meta_data,
    label_col = "LABEL"
   )
all.equal(study_data, sd2)
all.equal(sd1$v00013, sd2$v00013)
}
}
