% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_check_meta_names.R
\name{prep_check_meta_names}
\alias{prep_check_meta_names}
\title{Checks the validity of meta data w.r.t. the provided column names}
\usage{
prep_check_meta_names(meta_data, level, character.only = FALSE)
}
\arguments{
\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{level}{\link{enum} level of requirement (see also \link{VARATT_REQUIRE_LEVELS})}

\item{character.only}{\link{logical} a logical indicating whether level can be
assumed to be character strings.}
}
\value{
a logical with:
\itemize{
\item invisible(TRUE). In case of problems with the meta data, a condition is
raised (\code{stop()}).
}
}
\description{
This function verifies, if a data frame complies to meta data conventions and
provides a given richness of meta information as specified by \code{level}.
}
\details{
Note, that only the given level is checked despite, levels are somehow
hierarchical.
}
\examples{
prep_check_meta_names(data.frame(VAR_NAMES = 1, DATA_TYPE = 2,
                      MISSING_LIST = 3))

prep_check_meta_names(
  data.frame(
    VAR_NAMES = 1, DATA_TYPE = 2, MISSING_LIST = 3,
    LABEL = "LABEL", VALUE_LABELS = "VALUE_LABELS",
    JUMP_LIST = "JUMP_LIST", HARD_LIMITS = "HARD_LIMITS",
    KEY_OBSERVER = "KEY_OBSERVER", KEY_DEVICE = "KEY_DEVICE",
    KEY_DATETIME = "KEY_DATETIME",
    KEY_STUDY_SEGMENT = "KEY_STUDY_SEGMENT"
  ),
  RECOMMENDED
)

prep_check_meta_names(
  data.frame(
    VAR_NAMES = 1, DATA_TYPE = 2, MISSING_LIST = 3,
    LABEL = "LABEL", VALUE_LABELS = "VALUE_LABELS",
    JUMP_LIST = "JUMP_LIST", HARD_LIMITS = "HARD_LIMITS",
    KEY_OBSERVER = "KEY_OBSERVER", KEY_DEVICE = "KEY_DEVICE",
    KEY_DATETIME = "KEY_DATETIME", KEY_STUDY_SEGMENT =
      "KEY_STUDY_SEGMENT",
    DETECTION_LIMITS = "DETECTION_LIMITS", SOFT_LIMITS = "SOFT_LIMITS",
    CONTRADICTIONS = "CONTRADICTIONS", DISTRIBUTION = "DISTRIBUTION",
    DECIMALS = "DECIMALS", VARIABLE_ROLE = "VARIABLE_ROLE",
    DATA_ENTRY_TYPE = "DATA_ENTRY_TYPE",
    VARIABLE_ORDER = "VARIABLE_ORDER", LONG_LABEL =
      "LONG_LABEL", recode = "recode"
  ),
  OPTIONAL
)

# Next one will fail
try(
  prep_check_meta_names(data.frame(VAR_NAMES = 1, DATA_TYPE = 2,
    MISSING_LIST = 3), TECHNICAL)
)
}
