% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_generate_fielddescriptor.R
\name{dp_generate_fielddescriptor}
\alias{dp_generate_fielddescriptor}
\alias{dp_generate_fielddescriptor.default}
\alias{dp_generate_fielddescriptor.numeric}
\alias{dp_generate_fielddescriptor.integer}
\alias{dp_generate_fielddescriptor.logical}
\alias{dp_generate_fielddescriptor.Date}
\alias{dp_generate_fielddescriptor.character}
\alias{dp_generate_fielddescriptor.factor}
\alias{dp_generate_fielddescriptor.code}
\title{Generate a fielddescriptor for a given variable in a dataset}
\usage{
dp_generate_fielddescriptor(x, name, ...)

\method{dp_generate_fielddescriptor}{default}(x, name, ...)

\method{dp_generate_fielddescriptor}{numeric}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{integer}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{logical}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{Date}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{character}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{factor}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)

\method{dp_generate_fielddescriptor}{code}(
  x,
  name,
  use_existing = TRUE,
  use_categories = TRUE,
  categories_type = c("regular", "resource"),
  ...
)
}
\arguments{
\item{x}{vector for which to generate the fielddescriptor}

\item{name}{name of the field in the dataset.}

\item{...}{used to pass extra arguments to methods.}

\item{use_existing}{use existing field descriptor if present (assumes this is
stored in the 'fielddescriptor' attribute).}

\item{use_categories}{do not generate a categories field except when \code{x}
is a factor.}

\item{categories_type}{how should categories be stored. Note that type "resource"
is not officially part of the standard.}
}
\value{
Returns a \code{fielddescriptor}.
}
\description{
Generate a fielddescriptor for a given variable in a dataset
}
