/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;

public class ModelUtils {
    public static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isVariable()) {
            throw new QueryException("Variable: " + n);
        }
        if (model != null) {
            return model.asRDFNode(n);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, null);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + n);
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node sNode = t.getSubject();
        Node pNode = t.getPredicate();
        Node oNode = t.getObject();
        if (sNode.isLiteral() || sNode.isVariable()) {
            return null;
        }
        if (!pNode.isURI()) {
            return null;
        }
        if (oNode.isVariable()) {
            return null;
        }
        RDFNode s = ModelUtils.convertGraphNodeToRDFNode(sNode, model);
        RDFNode p = ModelUtils.convertGraphNodeToRDFNode(pNode, model);
        if (p instanceof Resource) {
            p = model.createProperty(((Resource)p).getURI());
        }
        RDFNode o = ModelUtils.convertGraphNodeToRDFNode(oNode, model);
        Statement stmt = model.createStatement((Resource)s, (Property)p, o);
        return stmt;
    }
}

