/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternOptimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.GraphStatisticsHeuristic;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.HeuristicBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.ProbabilisticFramework;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCounting;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityDataModel;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndexModel;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Set;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConfig
extends TestCase {
    private static long size;
    private static Model graphM;
    private static Set exProperty;
    private static final Property firstnameP;
    private static final Property lastnameP;
    private static final Property workplaceP;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";

    public TestConfig(String title) {
        super(title);
    }

    public static void oneTimeSetUp() {
        graphM = Util.readModel(testDataFileName);
        size = graphM.size();
        exProperty.add(firstnameP);
        exProperty.add(lastnameP);
        exProperty.add(workplaceP);
        exProperty.add(RDF.type);
        exProperty.add(RDF.first);
    }

    public static void oneTimeTearDown() {
        graphM.close();
    }

    public void testIndexLevel() {
        ProbabilityIndexModel probability = null;
        ProbabilityIndex index = null;
        Config config = new Config();
        config.setIndexLevel(1);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        index = probability.getIndex();
        TestConfig.assertTrue((index.getLevel() == 1 ? 1 : 0) != 0);
        TestConfig.assertTrue((index.allowsJoinedProbability() ? 1 : 0) != 0);
        Model indexM = ProbabilityFactory.createIndex(graphM, new Config(0));
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, config);
        index = probability.getIndex();
        TestConfig.assertTrue((index.getLevel() == 0 ? 1 : 0) != 0);
        TestConfig.assertTrue((!index.allowsJoinedProbability() ? 1 : 0) != 0);
    }

    public void testBasicPatternHeuristic() {
        BasicPatternOptimizer optimizer = null;
        HeuristicBasicPattern heuristic = null;
        Config config = new Config();
        config.setBasicPatternHeuristic("BGP_GRAPH_STATISTICS_HANDLER");
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, config);
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue((boolean)(heuristic instanceof GraphStatisticsHeuristic));
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, new Config("BGP_PROBABILISTIC_FRAMEWORK"));
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue((boolean)(heuristic instanceof ProbabilisticFramework));
        optimizer = new BasicPatternOptimizer(ARQ.getContext(), graphM.getGraph(), null, new Config("BGP_VARIABLE_COUNTING"));
        heuristic = optimizer.getHeuristicBasicPattern();
        TestConfig.assertTrue((boolean)(heuristic instanceof VariableCounting));
    }

    public void testExProperty() {
        ProbabilityIndexModel probability = null;
        ProbabilityIndex index = null;
        Set exclude = null;
        Config config = new Config();
        config.setExProperty(exProperty);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        index = probability.getIndex();
        exclude = index.getExProperty();
        TestConfig.assertTrue((boolean)exclude.containsAll(exProperty));
        TestConfig.assertFalse((boolean)exclude.contains(RDF.Bag));
        Model indexM = ProbabilityFactory.createIndex(graphM, new Config(exProperty));
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, config);
        index = probability.getIndex();
        exclude = index.getExProperty();
        TestConfig.assertTrue((boolean)exclude.containsAll(exProperty));
        TestConfig.assertFalse((boolean)exclude.contains(RDF.Bag));
    }

    public void testLimitMinProbability1() {
        ProbabilityIndexModel probability = null;
        Config config = new Config();
        config.setLimitMinProbability(false);
        probability = (ProbabilityIndexModel)ProbabilityFactory.createIndexModel(graphM, config);
        TestConfig.assertTrue((probability.getMinProbability() == Double.MIN_VALUE ? 1 : 0) != 0);
        TestConfig.assertTrue((probability.getMinJoinedProbability() == Double.MIN_VALUE ? 1 : 0) != 0);
        Model indexM = ProbabilityFactory.createIndex(graphM);
        probability = (ProbabilityIndexModel)ProbabilityFactory.loadIndexModel(graphM, indexM, new Config(true));
        TestConfig.assertTrue((probability.getMinProbability() == 1.0 / (double)size ? 1 : 0) != 0);
        TestConfig.assertTrue((probability.getMinJoinedProbability() == 1.0 / (double)(size * size) ? 1 : 0) != 0);
    }

    public void testLimitMinProbability2() {
        ProbabilityDataModel probability = null;
        probability = (ProbabilityDataModel)ProbabilityFactory.loadDataModel(graphM, new Config(false));
        TestConfig.assertTrue((probability.getMinProbability() == Double.MIN_VALUE ? 1 : 0) != 0);
        probability = (ProbabilityDataModel)ProbabilityFactory.loadDataModel(graphM, new Config(true));
        TestConfig.assertTrue((probability.getMinProbability() == 1.0 / (double)size ? 1 : 0) != 0);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("TestConfig");
        ts.addTest((Test)new TestConfig("testIndexLevel"));
        ts.addTest((Test)new TestConfig("testBasicPatternHeuristic"));
        ts.addTest((Test)new TestConfig("testExProperty"));
        ts.addTest((Test)new TestConfig("testLimitMinProbability1"));
        ts.addTest((Test)new TestConfig("testLimitMinProbability2"));
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestConfig.oneTimeSetUp();
            }

            protected void tearDown() {
                TestConfig.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    static {
        graphM = null;
        exProperty = new HashSet();
        firstnameP = ResourceFactory.createProperty((String)"http://example.org#firstname");
        lastnameP = ResourceFactory.createProperty((String)"http://example.org#lastname");
        workplaceP = ResourceFactory.createProperty((String)"http://example.org#workplace");
    }
}

