% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{carbohydrates2}
\alias{carbohydrates2}
\title{Concentracion de carbohydrates en tejidos de especies arboreas.}
\format{
Contiene 16 variables, como sigue:
\describe{
  \item{clima}{Clima de cada sitio: mediterraneo y templado.}
  \item{sitio}{Sitio o localidad (termmas:Termas de Chillan , antillanca:Antillanca area within Puyehue National Park,
              castillo:Cerro Castillo Natural Reserve, farellones:Farellones in Central Chile, 
              pyrenees: Sierra de Cutas area in Spanish Central Pyrenees,sierra:Sierra Nevada).}
\item{especie}{Nombre de la especie (lenga: Nothofagus pumilio, frangel: Kageneckia angustifolia,
               uncinata: Pinus uncinata, sylvestris: Pinus sylvestris).}
\item{tejido}{Tipo de tejido, new developing twings, stem sapwood and branches.}
\item{temporada}{Temporada de medicion (primavera y otoño).}
\item{clase.altitud}{Clase de altitud. "Treeline", intermediate named as "mid", and closed or
      montane forest named as "low".}
\item{arbol}{Codigo para el  arbol muestra.}
\item{sitio.arbol}{Codigo que combina sitio y arbol.}
\item{tss}{Value of concentrations soluble carbohydrate per mass unit.}
\item{st}{Value of concentrations starch per mass unit.}
\item{nsc}{Value of concentrations non structural carbohydrates per mass unit.}
\item{tss.nsc}{.}
\item{wd}{It might be 'wood density', but not sure.}
\item{tss.mv}{Value of concentrations soluble carbohydrate per volume unit.}
\item{st.mv}{Value of concentrations starch per volume unit.}
\item{nsc.mv}{Value of concentrations non structural carbohydrates per volume unit.}
 }
}
\source{
Los datos fueron obtenidos desde el repositorio DRYAD en \doi{10.5061/dryad.ks97h}.
}
\usage{
data(carbohydrates2)
}
\description{
Los datos contienen 863 observaciones, de carbohidratos totales solubles, almidon,
 y carbohidratos no estructurales. Las concentraciones por unidad de masa y por
 unidad de volumen, en tres tipos de tejidos al principio de la primaverda y 
 del otoño en 6-8 arboles adultos de diferentes especies en tres clases
  de altitudes, muestreados en sitios de Chile y España.
}
\examples{
data(carbohydrates2)    
head(carbohydrates2)
boxplot(nsc~especie, data=carbohydrates2) 
with(carbohydrates2, tapply(tss, list("Altitud"=clase.altitud, "Especies"=especie), mean))
}
\references{
Piper F, Vinegla B, Linares J, Camarero J, Cavieres L, Fajardo A. 2016. Mediterranean and temperate treelines are 
controlled by different environmental drivers. Journal Ecology. 104: 691-702.
}
\keyword{datasets}
