% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{biomass}
\alias{biomass}
\title{Contains tree-level biomass data for several species in Canada.}
\format{
\describe{
  \item{treenum}{Tree number.}
  \item{spp}{Species common name.}
  \item{dbh}{Diameter at breast height, in cm.}
  \item{height}{Total height, in m.}
  \item{totbiom}{Total biomass, in kg.}
  \item{bolebiom}{Stem biomass, in kg.}
  \item{branchbiom}{Branches biomass, in kg.}
  \item{foliagebiom}{Foliage biomass, in kg.}
 }
}
\source{
The data are provided courtesy of Prof. Timothy Gregoire at
the School of Forestry and Environmental Studies at Yale University (New Haven, CT, USA).
}
\usage{
biomass
}
\description{
Biomass component measurements for sample trees of four species. 
The species are Balsam fir (Abies balsamea), Black spruce (Picea mariana),
White birch (Betula papyrifera),  and White spruce (Picea glauca).
}
\examples{
head(biomass) 
table(biomass$spp)    
}
\keyword{datasets}
