% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_dm_cut.R
\name{special_dm_cut}
\alias{special_dm_cut}
\title{Special DM Cut to reset Death variable information past cut date}
\usage{
special_dm_cut(dataset_dm, dataset_cut, cut_var = DCUTDTM)
}
\arguments{
\item{dataset_dm}{Input DM SDTMv dataset}

\item{dataset_cut}{Input datacut dataset}

\item{cut_var}{Datacut date variable found in the \code{dataset_cut} dataset, default is \code{DCUTDTM}}
}
\value{
Input dataset plus a flag \code{DCUT_TEMP_REMOVE} to indicate which observations would be
dropped when a datacut is applied, and a flag \code{DCUT_TEMP_DTHCHANGE} to indicate which
observations have death occurring after data cut date for clearing
}
\description{
Applies patient cut if patient not in source DCUT, as well as
clearing death information within DM if death occurred after datacut date
}
\examples{

dcut <- tibble::tribble(
  ~USUBJID, ~DCUTDTC, ~DCUTDTM,
  "01-701-1015", "2014-10-20T23:59:59", lubridate::ymd_hms("2014-10-20T23:59:59"),
  "01-701-1023", "2014-10-20T23:59:59", lubridate::ymd_hms("2014-10-20T23:59:59")
)

dm <- tibble::tribble(
  ~USUBJID, ~DTHDTC, ~DTHFL,
  "01-701-1015", "2014-10-20", "Y",
  "01-701-1023", "2014-10-21", "Y",
)

special_dm_cut(
  dataset_dm = dm,
  dataset_cut = dcut,
  cut_var = DCUTDTM
)
}
\author{
Tim Barnett
}
\keyword{derive}
