% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datacheck.R
\name{has.ruleErrors}
\alias{has.ruleErrors}
\title{Quick check if a rule profile on a table has any errors.}
\usage{
has.ruleErrors(profile.rules)
}
\arguments{
\item{profile.rules}{a data.profile object}
}
\value{
boolean
}
\description{
Quick check if a rule profile on a table has any errors.
}
\examples{

# Get example data file with some errors in it
atbler <- system.file("examples/db-err.csv", package = "datacheck")
arule <- system.file("examples/rules1.R", package = "datacheck")

at <- read.csv(atbler, stringsAsFactors = FALSE)
ad <- read_rules(arule)

db_e <- datadict_profile(at, ad)

has_rule_errors(db_e) == TRUE 
}
\author{
Reinhard Simon
}
\seealso{
Other datadict: \code{\link{as.rules}};
  \code{\link{as_rules}}; \code{\link{datadict.profile}};
  \code{\link{datadict_profile}};
  \code{\link{has_rule_errors}};
  \code{\link{is.datadict.profile}};
  \code{\link{is_datadict_profile}};
  \code{\link{prep4rep}}; \code{\link{read.rules}};
  \code{\link{read_rules}}
}

