% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorManipulation.R
\name{unFactor}
\alias{unFactor}
\title{Unfactor factor with too many values}
\usage{
unFactor(dataSet, n_unfactor = 53, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{n_unfactor}{Number of max element in a factor (numeric, default to 53)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
Same dataSet (as a data.table) with less factor columns.
}
\description{
To unfactorize all columns that have more than a given amount of various values. This
 function will be usefull after using some reading functions that put every string as factor.
}
\details{
If a factor has (strictly) more than \code{n_unfactor} values it is unfactored. \cr
It is recommended to use \code{\link{findAndTransformNumerics}} and \code{\link{findAndTransformDates}} after this function.\cr
If \code{n_unfactor} is set to -1, nothing will be performed. \cr
If there are a lot of column that have been transformed, you might want to look at the 
documentation of your data reader in order to stop transforming everything into a factor.
}
\examples{
# Let's build a dataSet
dataSet <- data.frame(true_factor = factor(rep(c(1,2), 13)),
                      false_factor = factor(LETTERS))
                      
# Let's un factorize all factor that have more than 5 different values
dataSet <- unFactor(dataSet, n_unfactor = 5)
sapply(dataSet, class)
# Let's un factorize all factor that have more than 5 different values
dataSet <- unFactor(dataSet, n_unfactor = 0)
sapply(dataSet, class)

}
