% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyCaseIssues.R
\name{identifyCaseIssues}
\alias{identifyCaseIssues}
\title{A checkFunction for identifying case issues}
\usage{
identifyCaseIssues(v, nMax = 10)
}
\arguments{
\item{v}{A character, factor, haven_labelled or labelled variable to check.}

\item{nMax}{The maximum number of problematic values to report. 
Default is \code{10}. Set to \code{Inf} if all problematic values are to be included 
in the outputted message, or to \code{0} for no output.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether case issues where found),
\code{$message} (a message describing which values in \code{v} resulted
in case issues) and \code{$problemValues} (the problematic values
in their original format). Note that Only unique problematic values
are listed and they are presented in alphabetical order.
}
\description{
A \code{\link{checkFunction}} to be called from
\code{\link{check}} that identifies values in a vector
that appear multiple times with different case settings.
}
\examples{
 identifyCaseIssues(c("val", "b", "1", "1", "vAl", "VAL", "oh", "OH"))

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
