% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyOutliersTBStyle.R
\name{identifyOutliersTBStyle}
\alias{identifyOutliersTBStyle}
\title{A checkFunction for identifying outliers Turkey Boxstole style}
\usage{
identifyOutliersTBStyle(v, nMax = Inf, maxDecimals = 2)
}
\arguments{
\item{v}{A numeric, integer or Date variable to check.}

\item{nMax}{The maximum number of problematic values to report. Default is \code{Inf}, in which case
all problematic values are included in the outputted message.}

\item{maxDecimals}{A positive integer or \code{Inf}. Number of decimals used when
printing numerical values in the data summary and in problematic values from the
data checks. If \code{Inf}, no rounding is performed.}
}
\value{
A \code{\link{checkResult}} with three entires: 
\code{$problem} (a logical indicating whether outliers were found),
\code{$message} (a message describing which values are outliers) and 
\code{$problemValues} (the outlier values).
}
\description{
A checkFunction to be called from \code{\link{check}} that identifies outlier values
in a numeric/integer/Date variable by use of the Turkey Boxplot method (consistent witht the
\code{\link{boxplot}} function).
}
\details{
Outliers are defined in the style of Turkey Boxplots (consistent with the
\code{\link{boxplot}} function), i.e. as values  that are smaller than the 1st quartile minus
the inter quartile range (IQR) or greater than  the third quartile plus the IQR. 

For Date variables, the calculations are done on their raw numeric format (as 
obtained by using \code{\link{unclass}}), after which they are translated back to Dates.
Note that no rounding is performed for Dates, no matter the value of \code{maxDecimals}.
}
\examples{
 identifyOutliersTBStyle(c(1:10, 200, 200, 700))

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}}, 
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
