% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Climb}
\alias{Climb}
\title{Climb a tree from parent to children, by provided criteria.}
\usage{
#node$Climb(...)
Climb(node, ...)
}
\arguments{
\item{node}{The root node of the tree or subtree to climb}

\item{...}{an attribute name to searched value pairlist. For brevity, you can also provide a character vector.}
}
\value{
the \code{Node} having path \code{...}, or \code{NULL} if such a path does not exist
}
\description{
This method lets you climb the tree, from crutch to crutch. On each \code{Node}, the 
\code{Climb} finds the first child having attribute value equal to the the provided argument.
}
\examples{
data(acme)
acme$Climb('IT', 'Outsource')$name
acme$Climb('IT')$Climb('Outsource')$name

acme$Climb(name = 'IT')

acme$Climb(position = c(2, 1))
#or, equivalent:
acme$Climb(position = 2, position = 1)
acme$Climb(name = "IT", cost = 250000)

tree <- CreateRegularTree(5, 2)
tree$Climb(c("1", "1"), position = c(2, 2))$path

}
\seealso{
\code{\link{Node}}
}

