% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{print.Node}
\alias{print.Node}
\title{Print a \code{Node} in a human-readable fashion.}
\usage{
\method{print}{Node}(x, ..., pruneMethod = c("simple", "dist", NULL),
  limit = 100)
}
\arguments{
\item{x}{The Node}

\item{...}{Node attributes to be printed. Can be either a character (i.e. the name of a Node field),
a Node method, or a function taking a Node as a single argument. See \code{Get} for details on 
the meaning of \code{attribute}.}

\item{pruneMethod}{The method used to prune for printing. If NULL, the entire tree is displayed. If
"simple", then only the first \code{limit} nodes are displayed. If "dist", then Nodes are removed
everywhere in the tree, according to their level.}

\item{limit}{The maximum number of nodes to print. Can be \code{NULL} if the 
entire tree should be printed.}
}
\description{
Print a \code{Node} in a human-readable fashion.
}
\examples{
data(acme)
print(acme, "cost", "p")
print(acme, "cost", probability = "p")
print(acme, expectedCost = function(x) x$cost * x$p)
do.call(print, c(acme, acme$fieldsAll))

}

