% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_list.R
\name{as.list.Node}
\alias{ToListExplicit}
\alias{ToListSimple}
\alias{as.list.Node}
\title{Convert a \code{data.tree} structure to a list-of-list structure}
\usage{
\method{as.list}{Node}(x, mode = c("simple", "explicit"), unname = FALSE,
  nameName = ifelse(unname, "name", ""), childrenName = "children",
  rootName = "", ...)

ToListSimple(x, nameName = "name")

ToListExplicit(x, unname = FALSE, nameName = ifelse(unname, "name", ""),
  childrenName = "children")
}
\arguments{
\item{x}{The Node to convert}

\item{mode}{How the list is structured. "simple" (the default) will add children directly as nested lists.
"explicit" puts children in a separate nested list called \code{childrenName}}

\item{unname}{If TRUE, then the nested children list will not have named arguments. This
can be useful e.g. in the context of conversion to JSON, if you prefer the children to be
an array rather than named objects.}

\item{nameName}{The name that should be given to the name element}

\item{childrenName}{The name that should be given to the children nested list}

\item{rootName}{The name of the node. If provided, this overrides \code{Node$name}}

\item{...}{Additional parameters (ignored)}
}
\description{
Convert a \code{data.tree} structure to a list-of-list structure
}
\examples{
data(acme)

str(ToListSimple(acme))

str(ToListExplicit(acme))
str(ToListExplicit(acme, unname = TRUE))
str(ToListExplicit(acme, unname = TRUE, nameName = "id", childrenName = "descendants"))


}

