% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.bases.r
\name{gl.report.bases}
\alias{gl.report.bases}
\title{Summary of base pair frequencies}
\usage{
gl.report.bases(gl)
}
\arguments{
\item{gl}{-- name of the DArT genlight object [required]}
}
\value{
Matrix containing the percent frequencies of each base (A,C,T,G) and the transition and 
transversion frequencies.
}
\description{
This script calculates the frequencies of the four bases, and the frequency of transitions and
transversions in a DArT genlight object.
}
\details{
The script checks if trimmed sequences are included in the locus metadata, and if so, tallies up
the numbers of A,T,G and C bases. Only the reference state at the SNP locus is counted. Counts of transitions
and transversions assume that there is no directionality, that is C>T is the same as T>C, because
the reference state is arbitrary.
}
\examples{
lst <- gl.report.bases(testset.gl)
lst
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
