% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backpropagation.R
\name{backpropagation}
\alias{backpropagation}
\title{Backpropagation learning function}
\usage{
backpropagation(darch, trainData, targetData,
  bp.learnRate = getParameter(".bp.learnRate", rep(1, times =
  length(darch@layers))),
  bp.learnRateScale = getParameter(".bp.learnRateScale"),
  nesterovMomentum = getParameter(".darch.nesterovMomentum"),
  dropout = getParameter(".darch.dropout", rep(0, times = length(darch@layers)
  + 1), darch), dropConnect = getParameter(".darch.dropout.dropConnect"),
  matMult = getParameter(".matMult"), debugMode = getParameter(".debug", F),
  ...)
}
\arguments{
\item{darch}{An instance of the class \code{\linkS4class{DArch}}.}

\item{trainData}{The training data (inputs).}

\item{targetData}{The target data (outputs).}

\item{bp.learnRate}{Learning rates for backpropagation, length is either one
or the same as the number of weight matrices when using different learning
rates for each layer.}

\item{bp.learnRateScale}{The learn rate is multiplied by this value after
each epoch.}

\item{nesterovMomentum}{See \code{darch.nesterovMomentum} parameter of
\code{\link{darch}}.}

\item{dropout}{See \code{darch.dropout} parameter of \code{\link{darch}}.}

\item{dropConnect}{See \code{darch.dropout.dropConnect} parameter of
\code{\link{darch}}.}

\item{matMult}{Matrix multiplication function, internal parameter.}

\item{debugMode}{Whether debug mode is enabled, internal parameter.}

\item{...}{Further parameters.}
}
\value{
The trained deep architecture
}
\description{
This function provides the backpropagation algorithm for deep architectures.
}
\details{
The only backpropagation-specific, user-relevant parameters are
\code{bp.learnRate} and \code{bp.learnRateScale}; they can be passed to the
\code{\link{darch}} function when enabling \code{backpropagation} as the
fine-tuning function. \code{bp.learnRate} defines the backpropagation
learning rate and can either be specified as a single scalar or as a vector
with one entry for each weight matrix, allowing for per-layer learning rates.
\code{bp.learnRateScale} is a single scalar which contains a scaling factor
for the learning rate(s) which will be applied after each epoch.

Backpropagation supports dropout and uses the weight update function as
defined via the \code{darch.weightUpdateFunction} parameter of
\code{\link{darch}}.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, darch.fineTuneFunction = "backpropagation")
}
}
\references{
Rumelhart, D., G. E. Hinton, R. J. Williams, Learning 
  representations by backpropagating errors, Nature 323, S. 533-536, DOI: 
  10.1038/323533a0, 1986.
}
\seealso{
\code{\link{darch}}

Other fine-tuning functions: \code{\link{minimizeAutoencoder}},
  \code{\link{minimizeClassifier}},
  \code{\link{rpropagation}}
}

