% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intradayMarketMonitor.R
\name{intradayMarketMonitor}
\alias{intradayMarketMonitor}
\title{Intra-day market monitor}
\usage{
intradayMarketMonitor(symbol = "^GSPC", defaultTZ = "America/Chicago")
}
\arguments{
\item{symbol}{A character variable with symbol understood by \code{getQuote} from
package \pkg{quantmod}, default value is \dQuote{^GSPC}.}

\item{defaultTZ}{A character variable with the (local) timezone used for displaying
the data, default value is \dQuote{America/Chicagp}.}
}
\value{
Nothing is returned, but a display of the current price and the recent history
is updated, and the loops loops \sQuote{forever}.
}
\description{
Intra-day Market Monitor for Security Prices
}
\details{
This function periodically queries a public data source for a current price of given
symbol and updates an intra-daily chart for that security. A working example is symbol
\dQuote{^GSPC} for the S&P500 index which can be obtained in real-time during (New York)
trading hours. Other symbols may work.

An alternate version offering 24-hour coverage, for example for futures on Globex, is
being prepared.

The function could be further generalized in numerous way and should be considered
\sQuote{alpha}. Current default values are a 15 second sleep, and fixed cut-off times
for market open/close states corresponding to NYSE hours. The data history is reset to
the two most recent days at the close, amd the data is snapshot to file (with the
filename derived from the symbol, and the path given by \code{tools::R_user_dir}).
These parameters might become configuration parameters in the future.
}
\examples{
if (requireNamespace("quantmod", quietly)) {           # only suggested packages used
   suppressMessages({library(xts);library(quantmod)})  # dampen noise, add dang as needed
   intradayMarketMonitor()
}
}
\seealso{
\url{https://gist.github.com/joshuaulrich/ee11ef67b1461df399b84efd3c8f9f67#file-intraday-sp500-r}
}
\author{
Dirk Eddelbuettel extending and refactoring the original code by Josh Ulrich
}
