% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceac.R
\name{ceac}
\alias{ceac}
\title{Cost-Effectiveness Acceptability Curve (CEAC)}
\usage{
ceac(wtp, psa)
}
\arguments{
\item{wtp}{numeric vector with willingness-to-pay (WTP) thresholds}

\item{psa}{psa object from \code{\link{make_psa_obj}}}
}
\value{
An object of class \code{ceac} that can be visualized with \code{plot}. The \code{ceac}
object is a data.frame that shows the proportion of PSA samples for which each strategy at each
WTP threshold is cost-effective. The final column indicates whether or not the strategy at a
particular WTP is on the cost-efficient frontier.
}
\description{
\code{ceac} is used to compute and plot the cost-effectiveness acceptability
curves (CEAC) from a probabilistic sensitivity analysis (PSA) dataset.
}
\details{
\code{ceac} computes the probability of each of the strategies being
cost-effective at each \code{wtp} threshold. The returned object has classes
\code{ceac} and \code{data.frame}, and has its own plot method (\code{\link{plot.ceac}}).
}
\examples{
# psa input provided with package
data("example_psa")
example_psa_obj <- make_psa_obj(example_psa$cost, example_psa$effectiveness,
                    example_psa$parameters, example_psa$strategies)

# define wtp threshold vector (can also use a single wtp)
wtp <- seq(1e4, 1e5, by = 1e4)
ceac_obj <- ceac(wtp, example_psa_obj)
plot(ceac_obj) # see ?plot.ceac for options

# this is most useful when there are many strategies
# warnings are printed to describe strategies that
# have been filtered out
plot(ceac_obj, min_prob = 0.5)

# standard ggplot layers can be used
plot(ceac_obj) +
    labs(title = "CEAC", y = "Pr(Cost-effective) at WTP")

# the ceac object is also a data frame
head(ceac_obj)

# summary() tells us the regions of cost-effectiveness for each strategy.
# Note that the range_max column is an open parenthesis, meaning that the
# interval over which that strategy is cost-effective goes up to but does not include
# the value in the range_max column.
summary(ceac_obj)

}
\seealso{
\code{\link{plot.ceac}}, \code{\link{summary.ceac}}
}
\keyword{acceptability}
\keyword{cost-effectiveness}
\keyword{curves}
