% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psa.R
\name{make_psa_obj}
\alias{make_psa_obj}
\title{Create a PSA object}
\usage{
make_psa_obj(
  cost,
  effectiveness,
  parameters = NULL,
  strategies = NULL,
  currency = "$",
  other_outcome = NULL
)
}
\arguments{
\item{cost}{For the data.frame, each simulation should be a row and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{effectiveness}{For the data.frame, each simulation should be a row and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{parameters}{Data frame with values for each simulation (rows) and parameter (columns).
The column names should be the parameter names.}

\item{strategies}{vector with the names of the strategies. Due to requirements in
certain uses of this vector, this function uses \code{\link{make.names}} to modify
strategy names as necessary. It is strongly suggested that you follow the rules
in the \code{\link{make.names}} help page, to avoid unexpected errors.}

\item{currency}{symbol for the currency being used (ex. "$", "£")}

\item{other_outcome}{data.frame containing values for another user-defined outcome.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}
}
\value{
An object of class \code{psa}
}
\description{
Creates an object to hold probabilistic sensitivity analysis data,
while checking the data for validity. The object can then be
used for many standard cost-effectiveness analyses (see Details below).
}
\details{
The PSA object forms the backbone of one part of the \code{dampack} package.

A scatterplot of the cost-effectiveness plane may be shown by running \code{plot}
on the output of \code{make_psa_obj}.

Using this object, you may calculate:
\itemize{
  \item Cost-effectiveness acceptability curves (\code{\link{ceac}})
  \item Expected value of perfect information (\code{\link{calc_evpi}})
  \item Expected loss (\code{\link{calc_exp_loss}})
  \item One-way sensitivity analysis (\code{\link{owsa}})
  \item Two-way sensitivity analysis (\code{\link{twsa}})
  \item Metamodels (\code{\link{metamodel}})
}

In addition, the PSA may be converted to a base-case analysis by using \code{summary}
on the PSA object. The output of \code{summary} can be used in \code{\link{calculate_icers}}.
}
\examples{
# psa input provided with package
data("example_psa")
psa <- make_psa_obj(example_psa$cost, example_psa$effectiveness,
                    example_psa$parameters, example_psa$strategies)

# custom print and summary methods
print(psa)
summary(psa)

# custom plot method; see ?plot.psa for options
plot(psa)

}
\seealso{
\code{\link{summary.psa}}, \code{\link{plot.psa}}
}
