% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_pam.R
\name{cluster_pam}
\alias{cluster_pam}
\title{PAM (Partitioning Around Medoids)}
\usage{
cluster_pam(k = 1)
}
\arguments{
\item{k}{the number of clusters to generate.}
}
\value{
returns PAM object.
}
\description{
Clustering around representative data points (medoids) using \code{cluster::pam}.
}
\details{
More robust to outliers than k‑means. The intrinsic metric reported is the within‑cluster SSE to medoids.
}
\examples{
# setup clustering
model <- cluster_pam(k = 3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
\references{
Kaufman, L. and Rousseeuw, P. J. (1990). Finding Groups in Data: An Introduction to Cluster Analysis.
}
