% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_ean.R
\name{ts_norm_ean}
\alias{ts_norm_ean}
\title{Time Series Adaptive Normalization (Exponential Moving Average - EMA)}
\usage{
ts_norm_ean(remove_outliers = TRUE, nw = 0)
}
\arguments{
\item{remove_outliers}{logical: if TRUE (default) outliers will be removed.}

\item{nw}{windows size}
}
\value{
returns a \code{ts_norm_ean} object.
}
\description{
Creates a normalization object for time series data using an Exponential Moving Average (EMA) method.
This normalization approach adapts to changes in the time series and optionally removes outliers.
}
\examples{
# time series to normalize
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_ean()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
